/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions;

import com.cenqua.crucible.actions.BaseAction;
import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.fisheye.logging.Logs;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class RSSAction
extends BaseAction {
    private String siteurl = CrucibleFilter.getSiteURL();
    private CrucibleUser user = this.getCurrentUser();

    public void setUser(String userName) {
        this.user = CrucibleUserManager.getUserByName(userName);
    }

    public String execute() throws Exception {
        return "success";
    }

    public String getSiteurl() {
        return this.siteurl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getNotifications() {
        LinkedList<RSSItem> items = new LinkedList<RSSItem>();
        if (this.user != null) {
            try {
                this.beginTx();
                List recipients = NotificationManager.INSTANCE.getLatestNotifications(this.user, 20);
                for (Notification note : recipients) {
                    RSSItem item = new RSSItem();
                    if (note.getActioner() != null) {
                        item.setAuthor(note.getActioner().getEmailStr());
                    } else {
                        item.setAuthor(note.getReview().getModerator().getEmailStr());
                    }
                    item.setDate(note.getCreateDate());
                    item.setTitle(note.getRSSTitle());
                    item.setLink(note.getLink());
                    item.setDescription(note.getRSSNote());
                    item.setGuid(note.getId().toString());
                    items.add(item);
                }
                this.commitTx();
            }
            catch (Throwable e2) {
                Logs.APP_LOG.error((Object)e2.getMessage(), e2);
            }
            finally {
                this.rollbackTxIfNotCommited();
            }
        }
        return items;
    }

    public List getReviews() {
        LinkedList<RSSItem> items = new LinkedList<RSSItem>();
        HashSet<Review> reviews = new HashSet<Review>();
        String[] states = new String[]{"Approve", "Review", "Summarize"};
        reviews.addAll(ReviewManager.getReviewsInStates(states));
        for (Review review : reviews) {
            RSSItem item = new RSSItem();
            item.setAuthor(review.getAuthor().getEmailStr());
            item.setDate(review.getCreateDate());
            item.setTitle(review.getPermaId() + ": " + review.getName() + "(" + review.getStateName() + ")");
            item.setLink(this.siteurl + "cru/" + review.getPermaId());
            item.setDescription(item.getTitle());
            item.setGuid(review.getId().toString());
            items.add(item);
        }
        return items;
    }

    public class RSSItem {
        private String title;
        private Date date;
        private String author;
        private String link;
        private String description;
        private String guid;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getGuid() {
            return this.guid;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }
    }
}

