/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions;

import com.cenqua.crucible.actions.BaseAction;
import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.crucible.view.ReviewFilters;
import com.cenqua.crucible.view.RowDetail;
import com.cenqua.fisheye.util.NaturalComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSSReviewQueryAction
extends BaseAction {
    private LinkedHashMap<Integer, RowDetail> reviewDetails = null;
    private List filteredReviews = null;
    private ReviewFilters reviewFilters = new ReviewFilters(this.getCurrentUser());
    private String filter;
    private ReviewFilters.FilterDef customFD = this.reviewFilters.getCustomFilterDef();
    private String title;

    public void setUser(String userName) {
        CrucibleUser user = CrucibleUserManager.getUserByName(userName);
        this.reviewFilters.setUser(user);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilterDesc() {
        return ((ReviewFilters.FilterDef)this.getFilterDefsByName((String)this.filter).get((int)0)).filterDescription;
    }

    public String getFilterName() {
        return ((ReviewFilters.FilterDef)this.getFilterDefsByName((String)this.filter).get((int)0)).filterName;
    }

    public String getSiteurl() {
        return CrucibleFilter.getSiteURL();
    }

    public Date getDate() {
        return new Date();
    }

    public void setState(String[] state) {
        this.customFD.state = state;
    }

    public void setAuthor(String author) {
        this.customFD.author = CrucibleUserManager.getUserByName(author);
    }

    public void setModerator(String moderator) {
        this.customFD.moderator = CrucibleUserManager.getUserByName(moderator);
    }

    public void setCreator(String creator) {
        this.customFD.creator = CrucibleUserManager.getUserByName(creator);
    }

    public void setReviewer(String reviewer) {
        this.customFD.reviewer = CrucibleUserManager.getUserByName(reviewer);
    }

    public void setOrRoles(boolean orRoles) {
        this.customFD.orRoles = orRoles;
    }

    public void setComplete(Boolean complete) {
        this.customFD.complete = complete;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private List getFilterDefsByName(String name) {
        if (this.filter.equals("custom")) {
            ArrayList<ReviewFilters.FilterDef> filters = new ArrayList<ReviewFilters.FilterDef>();
            filters.add(this.customFD);
            return filters;
        }
        return this.reviewFilters.getFilterDefsByKey(name);
    }

    private List getFilteredReviewIds(String filter) {
        if (this.filteredReviews == null) {
            HashSet<Integer> results = new HashSet<Integer>();
            List filters = this.getFilterDefsByName(filter);
            for (ReviewFilters.FilterDef fd : filters) {
                List ids = ReviewManager.getReviewsAsRolesInStates(fd, this.title, "review.id", "review.id");
                for (Integer id : ids) {
                    Review r = ReviewManager.getById(id);
                    if (results.contains(id) || !ReviewUtil.principalCanDoReviewAction(CrucibleFilter.getCurrentPrincipal(), "action:viewReview", r)) continue;
                    results.add(id);
                }
            }
            this.filteredReviews = new LinkedList(results);
            Collections.sort(this.filteredReviews, NaturalComparator.REVERSE_INSTANCE);
        }
        return this.filteredReviews;
    }

    private List getFilteredReviewDetails(String filter) {
        LinkedHashMap<Integer, RowDetail> reviewDetails = this.getReviewDetailsMap();
        ArrayList<RowDetail> details = new ArrayList<RowDetail>();
        List reviewIds = this.getFilteredReviewIds(filter);
        for (Integer id : reviewIds) {
            details.add(reviewDetails.get(id));
        }
        return details;
    }

    private LinkedHashMap<Integer, RowDetail> getReviewDetailsMap() {
        if (this.reviewDetails == null) {
            this.reviewDetails = ReviewManager.getReviewDetailsMap();
        }
        return this.reviewDetails;
    }

    public List getFilterByName() {
        return this.getFilteredReviewDetails(this.filter);
    }

    public List getToReviewDetails() {
        return this.getFilteredReviewDetails("toReview");
    }

    public List getRequireMyApprovalDetails() {
        return this.getFilteredReviewDetails("requireMyApproval");
    }

    public List getToSummarizDetailse() {
        return this.getFilteredReviewDetails("toSummarize");
    }

    public List getOutForReviewDetails() {
        return this.getFilteredReviewDetails("outForReview");
    }

    public List getDraftsDetails() {
        return this.getFilteredReviewDetails("drafts");
    }

    public List getClosedDetails() {
        return this.getFilteredReviewDetails("closed");
    }

    public List getOpenDetails() {
        return this.getFilteredReviewDetails("open");
    }

    public List getAllReviewsDetails() {
        return this.getFilteredReviewDetails("allReviews");
    }

    public List getAllOpenReviewsDetails() {
        return this.getFilteredReviewDetails("allOpenReviews");
    }

    public List getAllClosedReviewsDetails() {
        return this.getFilteredReviewDetails("allClosedReviews");
    }
}

