/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.chart;

import com.cenqua.crucible.actions.BaseAction;
import com.cenqua.crucible.actions.search.comment.CommentSearchData;
import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.reports.PieChart;
import com.cenqua.crucible.reports.PieDatasetAdjuster;
import com.cenqua.crucible.reports.commentsDefects.DefectRepDatasetMaker;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.jfree.data.general.DefaultPieDataset;

public class DefectRepAction
extends BaseAction {
    private int w = 200;
    private int h = 100;
    private Project project;
    private String metric;
    private int maxSegments = 0;
    private CommentSearchData sd = new CommentSearchData();

    public void setH(int h2) {
        this.h = h2;
    }

    public void setW(int w) {
        this.w = w;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void setTo(String to) {
        this.sd.getPeriod().setToStr(to);
    }

    public void setFrom(String from) {
        this.sd.getPeriod().setFromStr(from);
    }

    public void setProject(String projKey) {
        ProjectManager pm = (ProjectManager)SpringContext.getComponent("projectManager");
        this.project = pm.getProjectByKey(projKey);
        this.sd.setProjectId(this.project.getId());
    }

    public CommentSearchData getSearch() {
        return this.sd;
    }

    public String execute() throws Exception {
        try {
            DefectRepDatasetMaker dataSetMaker = new DefectRepDatasetMaker(this.sd, this.metric);
            PieChart defectRepChart = new PieChart();
            CrucibleFilter.getResponse().setContentType(defectRepChart.getImageContentType());
            ServletOutputStream out = CrucibleFilter.getResponse().getOutputStream();
            DefaultPieDataset dataSet = PieDatasetAdjuster.adjustPieDataset(dataSetMaker.getPieDataSet(), this.maxSegments, 2.0);
            defectRepChart.renderChart((OutputStream)out, this.w, this.h, defectRepChart.createChart("", dataSet, true));
            return "none";
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)e2);
            return "none";
        }
    }

    public void setMaxSegments(int maxSegments) {
        this.maxSegments = maxSegments;
    }
}

