/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.chart;

import com.cenqua.crucible.actions.BaseAction;
import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.reports.Period;
import com.cenqua.crucible.reports.reviews.ReviewChart;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;

public class ReviewsAction
extends BaseAction {
    private int w = 200;
    private int h = 100;
    private Period period = new Period();
    private Project project;
    private String stateName = "Review";

    public ReviewsAction() {
        this.period.lastWeek();
        this.setProject("CR");
    }

    public void setH(int h2) {
        this.h = h2;
    }

    public void setW(int w) {
        this.w = w;
    }

    public void setFrom(String from) {
        this.period.setFromStr(from);
    }

    public void setTo(String to) {
        this.period.setToStr(to);
    }

    public void setProject(String projKey) {
        ProjectManager pm = (ProjectManager)SpringContext.getComponent("projectManager");
        this.project = pm.getProjectByKey(projKey);
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public String execute() throws Exception {
        try {
            ReviewChart reviewChart = new ReviewChart();
            CrucibleFilter.getResponse().setContentType(reviewChart.getImageContentType());
            ServletOutputStream out = CrucibleFilter.getResponse().getOutputStream();
            reviewChart.getRenderChart((OutputStream)out, this.w, this.h, this.period.getFrom(), this.period.getTo(), this.project, this.stateName);
            return "none";
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)e2);
            return "none";
        }
    }
}

