/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.comment;

import com.cenqua.crucible.actions.AjaxResponse;
import com.cenqua.crucible.actions.comment.BaseCommentAction;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.RevisionComment;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.RevisionCommentManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.util.LineRangeUtil;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.crucible.view.RevisionCommentDO;

public class RevisionCommentAjaxAction
extends BaseCommentAction
implements AjaxResponse {
    private String toLineRange;
    private String fromLineRange;
    private FileRevisionExtraInfo frx;
    private Comment comment;
    private FRXDO frxDO;
    private RevisionComment wholeRev;

    public void setFrxId(Integer frxId) {
        this.frx = FRXManager.getById(frxId);
    }

    public void setToLineRange(String toLineRange) {
        this.toLineRange = LineRangeUtil.filterLineString(toLineRange);
    }

    public void setFromLineRange(String fromLineRange) {
        this.fromLineRange = LineRangeUtil.filterLineString(fromLineRange);
    }

    public FRXDO getFrxDO() throws Exception {
        if (this.frxDO == null) {
            this.frxDO = this.makeFRXDO(this.frx);
        }
        return this.frxDO;
    }

    public RevisionCommentDO getRcDO() throws Exception {
        return this.getFrxDO().getRCDOFromComment(this.comment);
    }

    public Integer getFrxId() {
        return this.frx.getId();
    }

    public boolean isWhole() {
        return this.wholeRev != null;
    }

    public RevisionCommentDO getWholeRevisionComment() {
        return new RevisionCommentDO(this.wholeRev, null);
    }

    public Comment getComment() {
        return this.comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        try {
            RevisionComment rc;
            this.beginTx();
            if (!this.isAllowed()) {
                this.commitTx();
                this.setErrorMsg("Sorry you're not authorized to add a comment to this review now.");
                String string = "error";
                return string;
            }
            this.comment = this.makeComment();
            if (this.comment == null) {
                this.commitTx();
                String string = "error";
                return string;
            }
            if (this.toLineRange != null && !this.toLineRange.equals("")) {
                rc = RevisionCommentManager.createAndAddRevisionComment(this.comment, this.frx, this.frx.getFileRevision());
                rc.setLineRange(this.toLineRange);
            }
            if (this.fromLineRange != null && !this.fromLineRange.equals("")) {
                rc = RevisionCommentManager.createAndAddRevisionComment(this.comment, this.frx, this.frx.getFromRevision());
                rc.setLineRange(this.fromLineRange);
            }
            if ((this.fromLineRange == null || this.fromLineRange.equals("")) && (this.toLineRange == null || this.toLineRange.equals(""))) {
                this.wholeRev = RevisionCommentManager.createAndAddRevisionComment(this.comment, this.frx, this.frx.getFileRevision());
            }
            if (!this.comment.isDraft()) {
                NotificationManager.INSTANCE.noteCommented(this.getReview(), this.comment);
            }
            this.commitTx();
            String string = "success";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }
}

