/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.configuration.metrics;

import com.cenqua.crucible.configuration.metrics.FieldConstants;
import com.cenqua.crucible.configuration.metrics.InvalidCheckException;
import com.cenqua.crucible.metrics1.Field;
import com.cenqua.crucible.metrics1.FieldTypes;
import com.cenqua.crucible.metrics1.Option;
import com.cenqua.crucible.metrics1.Select;
import com.cenqua.crucible.model.CustomField;
import com.cenqua.crucible.model.managers.CustomFieldManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.DateHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldDefinition
implements FieldConstants {
    private Integer version;
    private String scope;
    private String name;
    private int type;
    private String label;
    private int restrictionType = 0;
    private int maxInclusive = Integer.MAX_VALUE;
    private int minInclusive = Integer.MIN_VALUE;
    private LinkedHashMap<String, Object> namedValues = new LinkedHashMap();
    private HashMap<Object, String> valuesNames = new HashMap();
    private String defaultValueKey;
    private boolean required = false;
    private boolean multiple = false;
    private boolean combo = false;

    public FieldDefinition() {
    }

    public FieldDefinition(Field field, String scope, Integer version) {
        this.consume(field);
        this.setScope(scope);
        this.setVersion(version);
    }

    public void consume(Field field) {
        this.setName(field.getName());
        this.setType(field.getType());
        this.setRequired(field.isSetRequired() && field.getRequired());
        if (field.isSetLabel()) {
            this.setLabel(field.getLabel());
        } else {
            this.setLabel(this.getName());
        }
        if (field.getType().isSetInteger() && (field.getType().getInteger().isSetMax() || field.getType().getInteger().isSetMin())) {
            this.setRestrictionType(1);
            try {
                if (field.getType().getInteger().isSetMax()) {
                    this.setMaxInclusive(field.getType().getInteger().getMax().intValue());
                }
                if (field.getType().getInteger().isSetMin()) {
                    this.setMinInclusive(field.getType().getInteger().getMin().intValue());
                }
            }
            catch (InvalidCheckException ice) {
                Logs.APP_LOG.error((Object)"Metrics Config error", (Throwable)ice);
            }
        }
        if (field.isSetSelect()) {
            Option[] options;
            Select select = field.getSelect();
            this.setMultiple(select.isSetMultiple() && select.getMultiple());
            this.setCombo(select.isSetCombo() && select.getCombo());
            if (this.isMultiple() || this.isCombo()) {
                this.setRestrictionType(3);
            } else {
                this.setRestrictionType(2);
            }
            for (Option option : options = field.getSelect().getOptionArray()) {
                this.addNamedValue(option.getStringValue(), this.makeValueFromString(option.getValue()));
                if (!option.isSetSelected() || !option.getSelected()) continue;
                this.setDefaultValueKey(option.getStringValue());
            }
        }
    }

    private Object makeValueFromString(String value) {
        switch (this.getType()) {
            case 1: {
                try {
                    return new Integer(value);
                }
                catch (NumberFormatException e2) {
                    Logs.APP_LOG.warn((Object)("Expected an integer for this field, got " + value));
                    return null;
                }
            }
            case 0: {
                return value;
            }
            case 2: {
                return Boolean.valueOf(value);
            }
            case 3: {
                Long date = DateHelper.parseDate(value, new Date().getTime(), TimeZone.getDefault());
                if (date != null) {
                    return new Date(date);
                }
                return null;
            }
        }
        return null;
    }

    public CustomField makeCustomField(String value) {
        CustomField field = CustomFieldManager.createField();
        if (this.isExclusiveSet()) {
            field.setValue(this.getNamedValue(value));
        } else {
            field.setValue(this.makeValueFromString(value));
        }
        field.setName(this.getName());
        field.setFieldScope(this.getScope());
        field.setConfigVersion(this.getVersion());
        return field;
    }

    public Integer getVersion() {
        return this.version;
    }

    private void setVersion(Integer version) {
        this.version = version;
    }

    public boolean isRequired() {
        return this.required;
    }

    private void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    private void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public boolean isCombo() {
        return this.combo;
    }

    private void setCombo(boolean combo) {
        this.combo = combo;
    }

    public String getScope() {
        return this.scope;
    }

    private void setScope(String scope) {
        this.scope = scope;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    private void setType(FieldTypes type) {
        if (type.isSetBoolean()) {
            this.type = 2;
            return;
        }
        if (type.isSetInteger()) {
            this.type = 1;
            return;
        }
        if (type.isSetString()) {
            this.type = 0;
        }
    }

    public String getLabel() {
        return this.label;
    }

    private void setLabel(String label) {
        this.label = label;
    }

    public int getRestrictionType() {
        return this.restrictionType;
    }

    private void setRestrictionType(int restrictionType) {
        this.restrictionType = restrictionType;
    }

    public int getMaxInclusive() {
        return this.maxInclusive;
    }

    private void setMaxInclusive(int maxInclusive) throws InvalidCheckException {
        if (this.restrictionType != 1 && this.type != 1) {
            throw new InvalidCheckException("Type and BoundaryType are not set to Integer and Bounded so you can't set an upper boudary.");
        }
        this.maxInclusive = maxInclusive;
    }

    public int getMinInclusive() {
        return this.minInclusive;
    }

    private void setMinInclusive(int minInclusive) throws InvalidCheckException {
        if (this.restrictionType != 1 && this.type != 1) {
            throw new InvalidCheckException("Type and BoundaryType are not set to Integer and Bounded so you can't set an lower boudary.");
        }
        this.minInclusive = minInclusive;
    }

    public void addNamedValue(String name, Object value) {
        this.namedValues.put(name, value);
        this.valuesNames.put(value, name);
    }

    public Object getNamedValue(String name) {
        return this.namedValues.get(name);
    }

    public String getValueName(Object value) {
        return this.valuesNames.get(value);
    }

    public LinkedHashMap getNamedValues() {
        return this.namedValues;
    }

    public Set<String> getNamedValueNames() {
        return this.namedValues.keySet();
    }

    public Set<Map.Entry<String, Object>> getNamedEntries() {
        return this.namedValues.entrySet();
    }

    public String getDefaultValueKey() {
        return this.defaultValueKey;
    }

    private void setDefaultValueKey(String defaultValueKey) {
        this.defaultValueKey = defaultValueKey;
    }

    public Object getDefaultValue() {
        if (this.defaultValueKey != null) {
            return this.namedValues.get(this.defaultValueKey);
        }
        return null;
    }

    public boolean checkValue(Object value) {
        switch (this.restrictionType) {
            case 0: 
            case 3: {
                return true;
            }
            case 1: {
                if (value instanceof Integer) {
                    int val = (Integer)value;
                    return val <= this.maxInclusive && val >= this.minInclusive;
                }
                return false;
            }
            case 2: {
                return this.namedValues.containsValue(value);
            }
        }
        return false;
    }

    public boolean isBounded() {
        return this.getRestrictionType() == 1;
    }

    public boolean isUnlimited() {
        return this.getRestrictionType() == 0;
    }

    public boolean isExclusiveSet() {
        return this.getRestrictionType() == 2;
    }

    public boolean isNonExclusiveSet() {
        return this.getRestrictionType() == 3;
    }

    public boolean isString() {
        return this.getType() == 0;
    }

    public boolean isInteger() {
        return this.getType() == 1;
    }

    public boolean isBoolean() {
        return this.getType() == 2;
    }

    public boolean isDate() {
        return this.getType() == 3;
    }
}

