/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.principalAssociations.AllUserPA;
import com.cenqua.crucible.model.principalAssociations.AnonymousPA;
import com.cenqua.crucible.model.principalAssociations.BasePrincipalAssociation;
import com.cenqua.crucible.model.principalAssociations.GroupPA;
import com.cenqua.crucible.model.principalAssociations.RolePA;
import com.cenqua.crucible.model.principalAssociations.UserPA;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionScheme {
    private Integer id;
    private String name;
    private Set<AnonymousPA> anonymousPAs;
    private Set<AllUserPA> allUsersPAs;
    private Set<UserPA> userPAs;
    private Set<GroupPA> groupPAs;
    private Set<RolePA> reviewRolePAs;

    public PermissionScheme() {
    }

    public PermissionScheme(String name) {
        this.name = name;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<AnonymousPA> getAnonymousPAs() {
        return this.anonymousPAs;
    }

    private void setAnonymousPAs(Set<AnonymousPA> anonymousPAs) {
        this.anonymousPAs = anonymousPAs;
    }

    public void addAnonAction(String actionName) {
        AnonymousPA pa;
        if (this.anonymousPAs == null) {
            this.anonymousPAs = new HashSet<AnonymousPA>();
        }
        if (!this.anonymousPAs.contains(pa = new AnonymousPA(this, actionName))) {
            PermissionManager.save(pa);
            this.anonymousPAs.add(pa);
        }
    }

    public void removeAnonAction(String actionName) {
        if (this.anonymousPAs == null) {
            return;
        }
        for (AnonymousPA pa : this.anonymousPAs) {
            if (!actionName.equals(pa.getActionName())) continue;
            PermissionManager.delete(pa);
            this.anonymousPAs.remove(pa);
            return;
        }
    }

    public Set<AllUserPA> getAllUsersPAs() {
        return this.allUsersPAs;
    }

    private void setAllUsersPAs(Set<AllUserPA> allUsersPAs) {
        this.allUsersPAs = allUsersPAs;
    }

    public void addAllUsersAction(String actionName) {
        AllUserPA pa;
        if (this.allUsersPAs == null) {
            this.allUsersPAs = new HashSet<AllUserPA>();
        }
        if (!this.allUsersPAs.contains(pa = new AllUserPA(this, actionName))) {
            PermissionManager.save(pa);
            this.allUsersPAs.add(pa);
        }
    }

    public void removeAllUsersAction(String actionName) {
        if (this.allUsersPAs == null) {
            return;
        }
        for (AllUserPA pa : this.allUsersPAs) {
            if (!actionName.equals(pa.getActionName())) continue;
            PermissionManager.delete(pa);
            this.allUsersPAs.remove(pa);
            return;
        }
    }

    public Set<UserPA> getUserPAs() {
        return this.userPAs;
    }

    private void setUserPAs(Set<UserPA> userPAs) {
        this.userPAs = userPAs;
    }

    public void addUserAction(String pid, String actionName) {
        UserPA pa;
        if (this.userPAs == null) {
            this.userPAs = new HashSet<UserPA>();
        }
        if (!this.userPAs.contains(pa = new UserPA(this, pid, actionName))) {
            PermissionManager.save(pa);
            this.userPAs.add(pa);
        }
    }

    public void clearUserAction(String actionName) {
        this.clearAction(actionName, this.userPAs);
    }

    public Set<GroupPA> getGroupPAs() {
        return this.groupPAs;
    }

    private void setGroupPAs(Set<GroupPA> groupPAs) {
        this.groupPAs = groupPAs;
    }

    public void addGroupAction(String pid, String actionName) {
        GroupPA pa;
        if (this.groupPAs == null) {
            this.groupPAs = new HashSet<GroupPA>();
        }
        if (!this.groupPAs.contains(pa = new GroupPA(this, pid, actionName))) {
            PermissionManager.save(pa);
            this.groupPAs.add(pa);
        }
    }

    public void clearGroupAction(String actionName) {
        this.clearAction(actionName, this.groupPAs);
    }

    public Set<RolePA> getReviewRolePAs() {
        return this.reviewRolePAs;
    }

    private void setReviewRolePAs(Set<RolePA> reviewRolePAs) {
        this.reviewRolePAs = reviewRolePAs;
    }

    public void addReviewRoleAction(String pid, String actionName) {
        RolePA pa;
        if (this.reviewRolePAs == null) {
            this.reviewRolePAs = new HashSet<RolePA>();
        }
        if (!this.reviewRolePAs.contains(pa = new RolePA(this, pid, actionName))) {
            PermissionManager.save(pa);
            this.reviewRolePAs.add(pa);
        }
    }

    public void clearReviewRoleAction(String actionName) {
        this.clearAction(actionName, this.reviewRolePAs);
    }

    private void clearAction(String actionName, Collection c2) {
        if (c2 == null) {
            return;
        }
        HashSet<BasePrincipalAssociation> removed = new HashSet<BasePrincipalAssociation>();
        for (Object pa : c2) {
            BasePrincipalAssociation bpa = (BasePrincipalAssociation)pa;
            if (!actionName.equals(bpa.getActionName())) continue;
            PermissionManager.delete(pa);
            removed.add(bpa);
        }
        c2.removeAll(removed);
    }
}

