/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.DbException;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project {
    private Integer id;
    private String name;
    private String key;
    private Set<CrucibleUser> defaultReviewerUsers;
    private Set<CrucibleUser> allowedReviewerUsers;
    private Set<String> defaultReviewerGroups;
    private Set<String> allowedReviewerGroups;
    private CrucibleUser defaultModerator;
    private String defaultRepositoryName;
    private Set<Review> reviews;
    private PermissionScheme permissionScheme;
    private boolean allowReviewersToJoin;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Set<CrucibleUser> getDefaultReviewerUsers() {
        return this.defaultReviewerUsers;
    }

    public void setDefaultReviewerUsers(Set<CrucibleUser> defaultReviewerUsers) {
        this.defaultReviewerUsers = defaultReviewerUsers;
    }

    public Set<CrucibleUser> getAllowedReviewerUsers() {
        return this.allowedReviewerUsers;
    }

    public Set<CrucibleUser> getAllowedReviewers() throws DbException {
        HashSet<CrucibleUser> allUsers = new HashSet<CrucibleUser>(this.getAllowedReviewerUsers());
        CrucibleUserManager cum = (CrucibleUserManager)SpringContext.getComponent("crucibleUserManager");
        for (String groupName : this.allowedReviewerGroups) {
            allUsers.addAll(cum.getGroupOfUsers(groupName));
        }
        return allUsers;
    }

    public void setAllowedReviewerUsers(Set<CrucibleUser> allowedReviewerUsers) {
        this.allowedReviewerUsers = allowedReviewerUsers;
    }

    public Set<String> getDefaultReviewerGroups() {
        return this.defaultReviewerGroups;
    }

    public Set<CrucibleUser> getDefaultReviewers() throws DbException {
        HashSet<CrucibleUser> allUsers = new HashSet<CrucibleUser>(this.getDefaultReviewerUsers());
        CrucibleUserManager cum = (CrucibleUserManager)SpringContext.getComponent("crucibleUserManager");
        for (String groupName : this.defaultReviewerGroups) {
            allUsers.addAll(cum.getGroupOfUsers(groupName));
        }
        return allUsers;
    }

    public void setDefaultReviewerGroups(Set<String> defaultReviewerGroups) {
        this.defaultReviewerGroups = defaultReviewerGroups;
    }

    public Set<String> getAllowedReviewerGroups() {
        return this.allowedReviewerGroups;
    }

    public void setAllowedReviewerGroups(Set<String> allowedReviewerGroups) {
        this.allowedReviewerGroups = allowedReviewerGroups;
    }

    public CrucibleUser getDefaultModerator() {
        return this.defaultModerator;
    }

    public void setDefaultModerator(CrucibleUser defaultModerator) {
        this.defaultModerator = defaultModerator;
    }

    public String getDefaultRepositoryName() {
        return this.defaultRepositoryName;
    }

    public void setDefaultRepositoryName(String defaultRepositoryName) {
        this.defaultRepositoryName = defaultRepositoryName;
    }

    public Set<Review> getReviews() {
        return this.reviews;
    }

    public void setReviews(Set<Review> reviews) {
        this.reviews = reviews;
    }

    public PermissionScheme getPermissionScheme() {
        return this.permissionScheme;
    }

    public void setPermissionScheme(PermissionScheme permissionScheme) {
        this.permissionScheme = permissionScheme;
    }

    public boolean isAllowReviewersToJoin() {
        return this.allowReviewersToJoin;
    }

    public void setAllowReviewersToJoin(boolean allowReviewersToJoin) {
        this.allowReviewersToJoin = allowReviewersToJoin;
    }
}

