/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class ReviewParticipant {
    private Integer id;
    private Review review;
    private CrucibleUser user = null;
    private boolean author = false;
    private boolean moderator = false;
    private boolean reviewer = false;
    private boolean allComplete = false;
    private Date lastRead = null;
    private Set completedFrxs;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public CrucibleUser getUser() {
        return this.user;
    }

    public void setUser(CrucibleUser user) {
        this.user = user;
    }

    public Review getReview() {
        return this.review;
    }

    public void setReview(Review review) {
        this.review = review;
    }

    public boolean isAuthor() {
        return this.author;
    }

    public void setAuthor(boolean author) {
        this.author = author;
        if (author) {
            this.reviewer = false;
        }
    }

    public boolean isModerator() {
        return this.moderator;
    }

    public void setModerator(boolean moderator) {
        this.moderator = moderator;
        if (moderator) {
            this.reviewer = false;
        }
    }

    public boolean isReviewer() {
        return this.reviewer;
    }

    public void setReviewer(boolean reviewer) {
        this.reviewer = reviewer;
        if (reviewer) {
            this.moderator = false;
            this.author = false;
        }
    }

    public boolean isAllComplete() {
        return this.allComplete;
    }

    public void setAllComplete(boolean allComplete) {
        this.allComplete = allComplete;
    }

    public Date getLastRead() {
        return this.lastRead;
    }

    public void setLastRead(Date lastRead) {
        this.lastRead = lastRead;
    }

    public Set getCompletedFrxs() {
        if (this.completedFrxs == null) {
            this.completedFrxs = new HashSet();
        }
        return this.completedFrxs;
    }

    public void setCompletedFrxs(Set completedFrxs) {
        this.completedFrxs = completedFrxs;
    }

    public void completeFrx(FileRevisionExtraInfo frx, boolean complete) {
        if (complete) {
            this.getCompletedFrxs().add(frx);
        } else if (this.getCompletedFrxs().contains(frx)) {
            this.getCompletedFrxs().remove(frx);
        }
    }

    public String toString() {
        return this.getId() + ": " + this.getUser().getUserName() + " - " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (o == null || !(o instanceof ReviewParticipant)) {
            return false;
        }
        Integer oid = ((ReviewParticipant)o).getId();
        return oid != null && this.id.equals(oid);
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }
}

