/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.fisheye.logging.Logs;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateManager {
    public static final StateManager INSTANCE = new StateManager();
    private LinkedHashMap<String, State> states = new LinkedHashMap();
    private Map<MetaState, Set<String>> metaGroups = new EnumMap<MetaState, Set<String>>(MetaState.class);
    private State unknown;

    public StateManager() {
        this.setupStates();
    }

    private void setupStates() {
        State draft = this.addState("Draft", "Draft", States.DRAFT_STATE, MetaState.DRAFT);
        State approval = this.addState("Approval", "Pending Approval", States.APPROVAL_STATE, MetaState.DRAFT);
        State review = this.addState("Review", "Under Review", States.REVIEW_STATE, MetaState.OPEN);
        State summarize = this.addState("Summarize", "Summarize", States.SUMMARIZE_STATE, MetaState.OPEN);
        State closed = this.addState("Closed", "Closed", States.CLOSED_STATE, MetaState.CLOSED);
        State dead = this.addState("Dead", "Abandoned", States.DEAD_STATE, MetaState.TRASH);
        State rejected = this.addState("Rejected", "Rejected", States.REJECTED_STATE, MetaState.TRASH);
        this.unknown = this.addState("Unknown", "Review needs fixing", States.NONE_STATE, null);
        draft.addTransition(approval, "action:submitReview", "Send to moderator");
        draft.addTransition(review, "action:approveReview", "Start Review");
        draft.addTransition(dead, "action:abandonReview", "Abandon");
        approval.addTransition(dead, "action:abandonReview", "Abandon");
        approval.addTransition(review, "action:approveReview", "Start Review");
        approval.addTransition(rejected, "action:rejectReview", "Reject");
        review.addTransition(summarize, "action:summarizeReview", "Summarize");
        review.addTransition(dead, "action:abandonReview", "Abandon");
        summarize.addTransition(closed, "action:closeReview", "Close");
        summarize.addTransition(review, "action:reopenReview", "Reopen");
        summarize.addTransition(dead, "action:abandonReview", "Abandon");
        rejected.addTransition(draft, "action:reopenReview", "Re-create Review");
        rejected.addTransition(dead, "action:abandonReview", "Abandon");
        closed.addTransition(review, "action:reopenReview", "Reopen");
        dead.addTransition(draft, "action:recoverReview", "Recover Abandoned Review");
        this.unknown.addTransition(review, "action:reopenReview", "Set to Review");
        this.unknown.addTransition(review, "action:abandonReview", "Delete Review");
        this.unknown.addTransition(review, "action:closeReview", "Close Review");
        summarize.addEntryScript("cleanup:");
        closed.addEntryScript("cleanup:");
        closed.addEntryScript("markReviewed:");
        approval.addStateChangeNotifactionRole(ReviewManager.MODERATOR);
        review.addStateChangeNotifactionRole(ReviewManager.AUTHOR);
        review.addStateChangeNotifactionRole(ReviewManager.REVIEWER);
        summarize.addStateChangeNotifactionRole(ReviewManager.AUTHOR);
        summarize.addStateChangeNotifactionRole(ReviewManager.REVIEWER);
        closed.addStateChangeNotifactionRole(ReviewManager.AUTHOR);
        closed.addStateChangeNotifactionRole(ReviewManager.REVIEWER);
        rejected.addStateChangeNotifactionRole(ReviewManager.AUTHOR);
        this.unknown.addStateChangeNotifactionRole(ReviewManager.MODERATOR);
    }

    private State addState(String stateName, String verbage, States stateType, MetaState ms) {
        State state = new State(stateName, verbage, stateType, ms);
        this.states.put(stateName.toLowerCase(Locale.US), state);
        if (ms != null) {
            Set<String> set = this.metaGroups.get((Object)ms);
            if (set == null) {
                set = new LinkedHashSet<String>();
                this.metaGroups.put(ms, set);
            }
            set.add(stateName);
        }
        return state;
    }

    public List getStateChangeNotificationRules(String state) {
        return this.getStateByName(state).getStateChangeNotificationRoles();
    }

    public State getStateByName(String stateName) {
        State ret = this.states.get(stateName.toLowerCase(Locale.US));
        if (ret == null) {
            Logs.APP_LOG.warn((Object)("Crucible State (" + stateName + ") not defined, returning \"Unknown\" state"));
            ret = this.unknown;
        }
        return ret;
    }

    public State getFirstState() {
        return this.states.values().iterator().next();
    }

    public List<State> getStates() {
        return new LinkedList<State>(this.states.values());
    }

    private State getStateByType(States stateType) {
        for (State state : this.states.values()) {
            if (state.getStateType() != stateType) continue;
            return state;
        }
        return null;
    }

    public State getDraftState() {
        return this.getStateByType(States.DRAFT_STATE);
    }

    public State getApprovalState() {
        return this.getStateByType(States.APPROVAL_STATE);
    }

    public State getReviewState() {
        return this.getStateByType(States.REVIEW_STATE);
    }

    public State getSummarizeState() {
        return this.getStateByType(States.SUMMARIZE_STATE);
    }

    public State getClosedState() {
        return this.getStateByType(States.CLOSED_STATE);
    }

    public State getRejectedState() {
        return this.getStateByType(States.REJECTED_STATE);
    }

    public State getDeadState() {
        return this.getStateByType(States.DEAD_STATE);
    }

    public State getUnknownState() {
        return this.getStateByType(States.NONE_STATE);
    }

    public String[] getDraftStateNames() {
        Set<String> set = this.metaGroups.get((Object)MetaState.DRAFT);
        return set.toArray(new String[set.size()]);
    }

    public String[] getOpenStateNames() {
        Set<String> set = this.metaGroups.get((Object)MetaState.OPEN);
        return set.toArray(new String[set.size()]);
    }

    public String[] getClosedStateNames() {
        Set<String> set = this.metaGroups.get((Object)MetaState.CLOSED);
        return set.toArray(new String[set.size()]);
    }

    private State[] getStatesForNames(Set<String> set) {
        State[] states = new State[set.size()];
        int i2 = 0;
        for (String s : set) {
            states[i2++] = this.getStateByName(s);
        }
        return states;
    }

    public State[] getDraftStates() {
        Set<String> set = this.metaGroups.get((Object)MetaState.DRAFT);
        return this.getStatesForNames(set);
    }

    public State[] getOpenStates() {
        Set<String> set = this.metaGroups.get((Object)MetaState.OPEN);
        return this.getStatesForNames(set);
    }

    public State[] getClosedStates() {
        Set<String> set = this.metaGroups.get((Object)MetaState.CLOSED);
        return this.getStatesForNames(set);
    }

    public String[] getAllStateNames() {
        return new String[]{this.getDraftState().getName(), this.getApprovalState().getName(), this.getReviewState().getName(), this.getSummarizeState().getName(), this.getClosedState().getName(), this.getRejectedState().getName(), this.getDeadState().getName(), this.getUnknownState().getName()};
    }

    public String[] getNotDeadStateNames() {
        return new String[]{this.getDraftState().getName(), this.getApprovalState().getName(), this.getReviewState().getName(), this.getSummarizeState().getName(), this.getClosedState().getName(), this.getRejectedState().getName(), this.getUnknownState().getName()};
    }

    public Set getSetOfStateNames() {
        return this.states.keySet();
    }

    public boolean isStateName(String name) {
        return this.states.keySet().contains(name.toLowerCase(Locale.US));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum States {
        NONE_STATE,
        DRAFT_STATE,
        APPROVAL_STATE,
        REVIEW_STATE,
        SUMMARIZE_STATE,
        CLOSED_STATE,
        DEAD_STATE,
        REJECTED_STATE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetaState {
        DRAFT,
        OPEN,
        CLOSED,
        TRASH;

    }
}

