/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserActionManager {
    private static UserActionManager INSTANCE;
    public static final String ACTION_VIEW = "action:viewReview";
    public static final String ACTION_CREATE = "action:createReview";
    public static final String ACTION_ABANDON = "action:abandonReview";
    public static final String ACTION_SUBMIT = "action:submitReview";
    public static final String ACTION_APPROVE = "action:approveReview";
    public static final String ACTION_REJECT = "action:rejectReview";
    public static final String ACTION_SUMMARIZE = "action:summarizeReview";
    public static final String ACTION_CLOSE = "action:closeReview";
    public static final String ACTION_REOPEN = "action:reopenReview";
    public static final String ACTION_RECOVER = "action:recoverReview";
    public static final String ACTION_COMPLETE = "action:completeReview";
    public static final String ACTION_UNCOMPLETE = "action:uncompleteReview";
    public static final String ACTION_COMMENT = "action:commentOnReview";
    public static final String ACTION_MOD_FILES = "action:modifyReviewFiles";
    private Map<String, Action> actionMap = new HashMap<String, Action>();

    public static synchronized UserActionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UserActionManager();
        }
        return INSTANCE;
    }

    public static void resetForTests() {
        INSTANCE = null;
    }

    private UserActionManager() {
        this.setUpActions();
        this.checkAndCreateDefaultPS();
    }

    private void setUpActions() {
        Action a2 = new Action(ACTION_VIEW, "View", "view a review");
        a2.addApplicablePA(PAType.ANON);
        a2.addApplicablePA(PAType.ALLUSERS);
        a2.addApplicablePA(PAType.USER);
        a2.addApplicablePA(PAType.GROUP);
        this.putAction(a2);
        a2 = new Action(ACTION_CREATE, "Create", "create a review");
        a2.addApplicablePA(PAType.ALLUSERS);
        a2.addApplicablePA(PAType.USER);
        a2.addApplicablePA(PAType.GROUP);
        this.putAction(a2);
        a2 = new Action(ACTION_ABANDON, "Abandon", "abandon (i.e. cancel) a review");
        a2.addApplicablePA(PAType.ALLUSERS);
        a2.addApplicablePA(PAType.USER);
        a2.addApplicablePA(PAType.GROUP);
        a2.addApplicablePA(PAType.ROLE);
        this.putAction(a2);
        a2 = new Action(ACTION_SUBMIT, "Submit", "submit a review to the moderator for approval");
        a2.addApplicablePA(PAType.ALLUSERS);
        a2.addApplicablePA(PAType.USER);
        a2.addApplicablePA(PAType.GROUP);
        a2.addApplicablePA(PAType.ROLE);
        this.putAction(a2);
        a2 = new Action(ACTION_APPROVE, "Approve", "approve a review (i.e. issue it to the reviewers)");
        a2.addApplicablePA(PAType.ALLUSERS);
        a2.addApplicablePA(PAType.USER);
        a2.addApplicablePA(PAType.GROUP);
        a2.addApplicablePA(PAType.ROLE);
        this.putAction(a2);
        a2 = new Action(ACTION_REJECT, "Reject", "reject a review submitted for approval");
        a2.addApplicablePA(PAType.ALLUSERS);
        a2.addApplicablePA(PAType.USER);
        a2.addApplicablePA(PAType.GROUP);
        a2.addApplicablePA(PAType.ROLE);
        this.putAction(a2);
        a2 = new Action(ACTION_SUMMARIZE, "Summarize", "summarize a review");
        a2.addApplicablePA(PAType.ALLUSERS);
        a2.addApplicablePA(PAType.USER);
        a2.addApplicablePA(PAType.GROUP);
        a2.addApplicablePA(PAType.ROLE);
        this.putAction(a2);
        a2 = new Action(ACTION_CLOSE, "Close", "close a review once it has been summarized");
        a2.addApplicablePA(PAType.ALLUSERS);
        a2.addApplicablePA(PAType.USER);
        a2.addApplicablePA(PAType.GROUP);
        a2.addApplicablePA(PAType.ROLE);
        this.putAction(a2);
        a2 = new Action(ACTION_REOPEN, "Re-Open", "re-open a closed review");
        a2.addApplicablePA(PAType.ALLUSERS);
        a2.addApplicablePA(PAType.USER);
        a2.addApplicablePA(PAType.GROUP);
        a2.addApplicablePA(PAType.ROLE);
        this.putAction(a2);
        a2 = new Action(ACTION_RECOVER, "Recover", "recover an abandoned review");
        a2.addApplicablePA(PAType.ALLUSERS);
        a2.addApplicablePA(PAType.USER);
        a2.addApplicablePA(PAType.GROUP);
        a2.addApplicablePA(PAType.ROLE);
        this.putAction(a2);
        a2 = new Action(ACTION_COMPLETE, "Complete", "indicate they have completed a review");
        a2.addApplicablePA(PAType.ALLUSERS);
        a2.addApplicablePA(PAType.USER);
        a2.addApplicablePA(PAType.GROUP);
        a2.addApplicablePA(PAType.ROLE);
        this.putAction(a2);
        a2 = new Action(ACTION_UNCOMPLETE, "Uncomplete", "indicate they have not completed a review, after indicating they have completed a review");
        a2.addApplicablePA(PAType.ALLUSERS);
        a2.addApplicablePA(PAType.USER);
        a2.addApplicablePA(PAType.GROUP);
        a2.addApplicablePA(PAType.ROLE);
        this.putAction(a2);
        a2 = new Action(ACTION_COMMENT, "Comment", "add or remove a comment on a review");
        a2.addApplicablePA(PAType.ALLUSERS);
        a2.addApplicablePA(PAType.USER);
        a2.addApplicablePA(PAType.GROUP);
        a2.addApplicablePA(PAType.ROLE);
        this.putAction(a2);
        a2 = new Action(ACTION_MOD_FILES, "Edit Review Details", "change review details including the set of revisions being reviewed");
        a2.addApplicablePA(PAType.ALLUSERS);
        a2.addApplicablePA(PAType.USER);
        a2.addApplicablePA(PAType.GROUP);
        a2.addApplicablePA(PAType.ROLE);
        this.putAction(a2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndCreateDefaultPS() {
        HibernateUtil.beginTransaction();
        try {
            PermissionScheme ps = PermissionManager.getDefaultPermissionScheme();
            if (ps != null) {
                HibernateUtil.commitTransaction();
                return;
            }
            ps = PermissionManager.createDefaultPS();
            ps.addAllUsersAction(ACTION_VIEW);
            ps.addReviewRoleAction(ReviewManager.REVIEWER.getName(), ACTION_VIEW);
            ps.addReviewRoleAction(ReviewManager.CREATOR.getName(), ACTION_VIEW);
            ps.addReviewRoleAction(ReviewManager.MODERATOR.getName(), ACTION_VIEW);
            ps.addReviewRoleAction(ReviewManager.AUTHOR.getName(), ACTION_VIEW);
            ps.addAllUsersAction(ACTION_CREATE);
            ps.addReviewRoleAction(ReviewManager.CREATOR.getName(), ACTION_ABANDON);
            ps.addReviewRoleAction(ReviewManager.CREATOR.getName(), ACTION_SUBMIT);
            ps.addReviewRoleAction(ReviewManager.MODERATOR.getName(), ACTION_ABANDON);
            ps.addReviewRoleAction(ReviewManager.MODERATOR.getName(), ACTION_APPROVE);
            ps.addReviewRoleAction(ReviewManager.MODERATOR.getName(), ACTION_REJECT);
            ps.addReviewRoleAction(ReviewManager.MODERATOR.getName(), ACTION_SUMMARIZE);
            ps.addReviewRoleAction(ReviewManager.MODERATOR.getName(), ACTION_CLOSE);
            ps.addReviewRoleAction(ReviewManager.MODERATOR.getName(), ACTION_REOPEN);
            ps.addReviewRoleAction(ReviewManager.REVIEWER.getName(), ACTION_COMPLETE);
            ps.addReviewRoleAction(ReviewManager.REVIEWER.getName(), ACTION_UNCOMPLETE);
            ps.addReviewRoleAction(ReviewManager.REVIEWER.getName(), ACTION_COMMENT);
            ps.addReviewRoleAction(ReviewManager.CREATOR.getName(), ACTION_COMMENT);
            ps.addReviewRoleAction(ReviewManager.MODERATOR.getName(), ACTION_COMMENT);
            ps.addReviewRoleAction(ReviewManager.AUTHOR.getName(), ACTION_COMMENT);
            ps.addReviewRoleAction(ReviewManager.CREATOR.getName(), ACTION_MOD_FILES);
            ps.addReviewRoleAction(ReviewManager.MODERATOR.getName(), ACTION_MOD_FILES);
            ps.addReviewRoleAction(ReviewManager.CREATOR.getName(), ACTION_RECOVER);
            ps.addReviewRoleAction(ReviewManager.MODERATOR.getName(), ACTION_RECOVER);
            HibernateUtil.commitTransaction();
        }
        finally {
            HibernateUtil.closeSession();
        }
    }

    private void putAction(Action a2) {
        this.actionMap.put(a2.getName(), a2);
    }

    public Action getAction(String name) {
        return this.actionMap.get(name);
    }

    public Collection<Action> getActions() {
        return this.actionMap.values();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Action {
        private final String name;
        private final String displayName;
        private final String permissionDescription;
        private final Set<PAType> allowedPATs = new HashSet<PAType>();

        public Action(String name, String displayName, String permissionDescription) {
            this.name = name;
            this.displayName = displayName;
            this.permissionDescription = permissionDescription;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getPermissionDescription() {
            return this.permissionDescription;
        }

        public String getPermissionViolationMsg() {
            return "you are not authorized to " + this.permissionDescription;
        }

        public void addApplicablePA(PAType type) {
            this.allowedPATs.add(type);
        }

        public Set<PAType> getApplicablePATs() {
            return this.allowedPATs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PAType {
        ANON,
        ALLUSERS,
        USER,
        GROUP,
        ROLE;

    }
}

