/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.fisheye.AppConfig;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.List;

public class StateNotification
extends Notification {
    private static final String STATE_CLOSED_TEMPLATE = "state-closed-notification.ftl";
    private static final String STATE_CHANGED_TEMPLATE = "state-changed-notification.ftl";

    public StateNotification() {
    }

    public StateNotification(CrucibleUser actioner, Review review) {
        super(actioner);
        this.setReview(review);
        this.setNote(review.getStateName());
    }

    protected Integer getType() {
        return NotificationManager.TYPE_STATE_CHANGE;
    }

    public String getLink() {
        return AppConfig.getsConfig().getSiteURL() + "cru/" + this.getReview().getPermaId();
    }

    public String getState() {
        return this.getNote();
    }

    public String getEmailSubject() {
        return "[" + this.getReview().getPermaId() + "] " + this.getState() + ": " + this.getReview().getName();
    }

    protected String getEmailTemplateName() {
        State state = StateManager.INSTANCE.getStateByName(this.getState());
        if (state.isClosedState()) {
            return STATE_CLOSED_TEMPLATE;
        }
        return STATE_CHANGED_TEMPLATE;
    }

    public String getRSSNote() throws IOException, TemplateException {
        return this.getEmailNote();
    }

    public String getRSSTitle() {
        return this.getReview().getPermaId() + ": " + this.getState();
    }

    public String getDescription() {
        return "State Change";
    }

    public List getRolesToNotify() {
        return StateManager.INSTANCE.getStateChangeNotificationRules(this.getState());
    }

    public Integer getEmailNotificationPref(CrucibleUser user) {
        return user.getStateChangeEmailNotification();
    }

    public Integer getRssNotificationPref(CrucibleUser user) {
        return user.getCompleteEmailNotification();
    }
}

