/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.tags;

import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.web.tags.AbstractRegionListTag;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;

public class UserTextRendererTag
extends AbstractRegionListTag {
    private String text;
    private String repname;

    public void setText(String text) {
        this.text = text;
    }

    public void setReview(Review review) {
        if (review != null) {
            this.repname = review.getRepoName();
        }
    }

    public void doTag() throws IOException {
        RegionList regions = this.makeRegions();
        this.outputRegion(this.text, regions, 0, this.text.length());
    }

    private RegionList makeRegions() {
        RegionList regions = new RegionList();
        regions.add(new Region(0, this.text.length(), Collections.singletonMap("findlinks", "true")));
        Linker l = this.makeLinker();
        l.insertLinks(this.text, regions);
        return regions;
    }

    private Linker makeLinker() {
        Source s;
        Linker linker = null;
        if (StringUtils.isNotEmpty((String)this.repname) && (s = CrucibleFilter.getSource(Source.getRepoSourceName(this.repname))) instanceof RepositorySource && s.isAvailable()) {
            linker = ((RepositorySource)s).getRepositoryHandle().getCfg().getLinker();
        }
        if (linker == null) {
            linker = AppConfig.getsConfig().getDefaultLinker();
        }
        return linker;
    }

    protected String getSpanClass(Region region) {
        return null;
    }
}

