/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.SyntaxDefinitions;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.vis.AnnotationColourer;
import com.cenqua.fisheye.vis.AnnotationColourerFactory;
import com.cenqua.fisheye.web.CookiePreferences;
import java.io.File;

public class AnnotateDO {
    private FRXDO frxDO;
    private CookiePreferences prefs;
    private boolean eolTerminated;
    private final AnnotationColourer colourer;
    private final RegionList regions;
    private final String syntaxname;
    private final IndexedLineReader lines;
    private final Blame annotator;

    public AnnotateDO(FRXDO frx, CookiePreferences prefs) throws Exception {
        this.frxDO = frx;
        this.prefs = prefs;
        Disposer disposer = Disposer.threadInstance();
        Source s = this.frxDO.getSource();
        if (!s.isAvailable()) {
            throw s.getException();
        }
        FileRevision toRev = this.frxDO.getToRevision();
        Blame annotator = s.getBlame(toRev);
        File tmpFile = File.createTempFile("crucible", null);
        disposer.deleteFileOnDispose(tmpFile);
        IndexedLineReader lines = s.getFileContents(toRev, tmpFile, null);
        disposer.add(lines);
        lines.scanRestOfFile();
        SyntaxDefinitions synDefs = AppConfig.getsConfig().getSyntaxDefinitions();
        SyntaxDefinitions.ParseResult synhi = synDefs.getRegionsForFile(toRev.getPath(), lines.getCharSequence());
        RegionList regions = synhi.getRegions();
        s.insertLinks(lines.getCharSequence(), regions);
        this.eolTerminated = lines.isEolTerminated();
        this.colourer = AnnotationColourerFactory.create(annotator, prefs.getPreference("annotateMode"));
        this.regions = regions;
        this.syntaxname = synhi.getSyntaxDefinition().getName().toLowerCase();
        this.lines = lines;
        this.annotator = annotator;
    }

    public boolean isEolTerminated() {
        return this.eolTerminated;
    }

    public AnnotationColourer getColourer() {
        return this.colourer;
    }

    public RegionList getRegions() {
        return this.regions;
    }

    public String getSyntaxname() {
        return this.syntaxname;
    }

    public IndexedLineReader getLines() {
        return this.lines;
    }

    public Blame getAnnotator() {
        return this.annotator;
    }
}

