/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.util.AntGlob;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllowRules {
    private final List<Path> allowDirs;
    private final List<AntGlob> disallowPatterns;

    public AllowRules(List<Path> allowDirs, List<AntGlob> dissallowPatterns) {
        this.allowDirs = allowDirs;
        this.disallowPatterns = dissallowPatterns;
    }

    public List<Path> getIncludes() {
        return Collections.unmodifiableList(this.allowDirs);
    }

    public boolean isIgnored(Path path) {
        if (!this.allowDirs.isEmpty()) {
            boolean included = false;
            Iterator<Path> i2 = this.allowDirs.iterator();
            while (!included && i2.hasNext()) {
                Path allowdir = i2.next();
                if (!path.hasPrefix(allowdir) && !allowdir.hasPrefix(path)) continue;
                included = true;
            }
            if (!included) {
                return true;
            }
        }
        if (this.disallowPatterns.isEmpty()) {
            return false;
        }
        String s = "/" + path.toString();
        for (AntGlob disallowPattern : this.disallowPatterns) {
            if (!disallowPattern.matches(s)) continue;
            return true;
        }
        return false;
    }
}

