/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.util.MD5;

public class AdminConfig {
    private final ConfigDocument.Config mConfig;

    public AdminConfig(ConfigDocument.Config config) {
        this.mConfig = config;
    }

    public boolean haveDoneInitialSetup() {
        return this.mConfig.isSetAdminHash();
    }

    public boolean isAdminEnabled() {
        return this.mConfig.isSetAdminHash() && this.mConfig.getAdminHash().length() != 0;
    }

    public void updateAdminPassword(String password) {
        if (password == null) {
            if (this.mConfig.isSetAdminHash()) {
                this.mConfig.unsetAdminHash();
            }
        } else if (password.length() == 0) {
            this.mConfig.setAdminHash("");
        } else {
            this.mConfig.setAdminHash(this.hash(password));
        }
    }

    public boolean verifyAdminPassword(String password) {
        if (this.mConfig.isSetAdminHash()) {
            String h2 = this.hash(password);
            return h2.equalsIgnoreCase(this.mConfig.getAdminHash());
        }
        return false;
    }

    private String hash(String str) {
        return MD5.hash(str).toUpperCase();
    }
}

