/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.cenqua.fisheye.config.PropertiesContainer;
import com.cenqua.fisheye.config1.PropertiesType;
import com.cenqua.fisheye.config1.PropertyType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.ComputingUnitExpander;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.util.XmlbeansUtil;

public class ConfigProperty {
    private final PropertiesContainer[] properties;
    private final String name;
    private final String defaultValue;

    public ConfigProperty(PropertiesContainer[] properties, String name, String defaultValue) {
        this.properties = properties;
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSet() {
        return this.findStringProperty(0, false) != null;
    }

    public String getValue() {
        String property = this.findStringProperty(0, true);
        return property == null ? this.defaultValue : property;
    }

    public void setValue(String value) {
        this.storeProperty(this.properties[0], this.name, value);
    }

    public boolean getBooleanValue() {
        return ConfigProperty.toBool(this.getValue());
    }

    public long getComputingUnitValue() {
        try {
            return ComputingUnitExpander.fromString(this.getValue());
        }
        catch (NumberFormatException e2) {
            Logs.APP_LOG.warn((Object)("could not parse property " + this.name), (Throwable)e2);
            return ComputingUnitExpander.fromString(this.defaultValue);
        }
    }

    public int getIntValue() {
        try {
            return Integer.parseInt(this.getValue());
        }
        catch (NumberFormatException e2) {
            Logs.APP_LOG.warn((Object)("could not parse int property " + this.name), (Throwable)e2);
            return Integer.parseInt(this.defaultValue);
        }
    }

    public String getParentValue() {
        String property = this.findStringProperty(1, true);
        return property == null ? this.defaultValue : property;
    }

    private String findStringProperty(int startIndex, boolean checkAll) {
        boolean keepGoing = true;
        for (int i2 = startIndex; i2 < this.properties.length && keepGoing; ++i2) {
            keepGoing = checkAll;
            PropertiesContainer pc = this.properties[i2];
            PropertiesType propertiesType = pc.getProperties();
            for (int j = 0; propertiesType != null && j < propertiesType.getPropertyArray().length; ++j) {
                PropertyType propertyType = propertiesType.getPropertyArray()[j];
                if (!this.name.equals(propertyType.getName())) continue;
                return propertyType.getValue();
            }
        }
        return null;
    }

    private static boolean toBool(String str) {
        if ("true".equalsIgnoreCase(str)) {
            return true;
        }
        if ("false".equalsIgnoreCase(str)) {
            return false;
        }
        return false;
    }

    public static void cleanup(PropertiesContainer pc) {
        if (pc.isSetProperties() && pc.getProperties().sizeOfPropertyArray() == 0) {
            pc.unsetProperties();
        }
    }

    private void storeProperty(PropertiesContainer pc, String name, String value) {
        boolean delete = StringUtil.nullOrEmpty(value);
        if (!pc.isSetProperties()) {
            if (delete) {
                return;
            }
            PropertiesType newprops = pc.addNewProperties();
            XmlbeansUtil.placeOnNewLine(newprops, 2);
        }
        PropertiesType props = pc.getProperties();
        PropertyType prop = null;
        int propIdx = 0;
        for (int j = 0; j < props.getPropertyArray().length; ++j) {
            PropertyType propertyType = props.getPropertyArray()[j];
            if (!name.equals(propertyType.getName())) continue;
            prop = propertyType;
            propIdx = j;
            break;
        }
        if (delete) {
            if (prop != null) {
                props.removeProperty(propIdx);
            }
            return;
        }
        if (prop == null) {
            prop = props.addNewProperty();
            prop.setName(name);
            XmlbeansUtil.placeOnNewLine(prop, 3);
        }
        prop.setValue(value);
    }
}

