/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.cenqua.fisheye.cvsrep.cache.CvsCSID;
import com.cenqua.fisheye.cvsrep.cache.CvsRevInfo;
import com.cenqua.fisheye.cvsrep.cache.infdb.InfDbRevisionInfoCache;
import com.cenqua.fisheye.cvsrep.cache.infdb.RevInfoEAV;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.AnyLongRangeQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermQuery3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import gnu.trove.TIntArrayList;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

public class CachedChangesetUpdater {
    public static final int CHANGESET_DATE_THRESHOLD = 600000;
    private static final int BATCH_SIZE = 100;
    private final InfDbRevisionInfoCache mDB;
    private final RepositoryStatus mStatus;
    private final SimpleDateFormat mStatusDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    private final InfinityDbHandle dbh;
    private boolean foundChanges = false;

    public CachedChangesetUpdater(RepositoryStatus st, InfinityDbHandle dbh, InfDbRevisionInfoCache db) {
        this.mDB = db;
        this.dbh = dbh;
        this.mStatus = st;
    }

    public boolean foundChanges() {
        return this.foundChanges;
    }

    public void processSomeChangesets(long noLaterThan) throws DbException {
        this.foundChanges = false;
        this.process(noLaterThan);
    }

    private void process(long noLaterThan) throws DbException {
        long date;
        Logs.APP_LOG.debug((Object)"Scanning for changesets");
        NextDateIterator dateIterator = new NextDateIterator(this.dbh.get());
        int numProcessed = 0;
        while (dateIterator.hasNextDate() && !this.mStatus.isStopRequested() && numProcessed <= 100 && (date = dateIterator.nextDate()) < noLaterThan) {
            this.mStatus.setMessage("scanning for changesets from " + this.mStatusDateFormat.format(new Date(date)));
            TIntArrayList revIds = dateIterator.nextRevids();
            ArrayList<CvsRevInfo> revs = new ArrayList<CvsRevInfo>(revIds.size());
            for (int i2 = 0; i2 < revIds.size(); ++i2) {
                int revid = revIds.get(i2);
                CvsRevInfo ri = this.mDB.findRevInfo(revid);
                if (ri == null) {
                    Logs.APP_LOG.error((Object)("BUG: unable to insert revision into a changeset: revid=" + revid));
                    continue;
                }
                revs.add(ri);
            }
            Collections.sort(revs, RevInfoPathComparator.INSTANCE);
            for (CvsRevInfo ri : revs) {
                this.assignToChangeset(ri);
                this.foundChanges = true;
                ++numProcessed;
            }
        }
    }

    private void assignToChangeset(CvsRevInfo ri) throws DbException {
        try {
            long minDate = ri.getDate() - 600000L;
            long maxDate = ri.getDate();
            AndQuery3 q = new AndQuery3();
            q.addClause(new TermQuery3(RevInfoEAV.E_ISCSMARKER_TO_REVID, true, RevInfoEAV.A_REVID));
            long cmtid = this.mDB.getCommentId(ri.getComment());
            q.addClause(new TermQuery3(CommonSchema.E_COMMENT_ID_TO_REVID, cmtid, null));
            q.addClause(new TermQuery3(CommonSchema.E_MOD_ON_BRANCH_TO_REVID, ri.getBranch(), null));
            String author = ri.getAuthor();
            if (author == null) {
                author = "";
            }
            q.addClause(new TermQuery3(CommonSchema.E_AUTHOR_TO_REVID, author.toLowerCase(Locale.US), null));
            q.addClause(new AnyLongRangeQuery3(CommonSchema.E_DATE_TO_REVID, minDate, true, maxDate, true));
            CvsCSID destcs = null;
            _ItemSpace ids = q.asItemSpace((_ItemSpace)this.dbh.get(), (LuceneConnection)null);
            _Cu cu = _Cu.alloc();
            while (ids.next(cu)) {
                int csrevid = (int)cu.longAt(0);
                CvsRevInfo csri = this.mDB.findRevInfo(csrevid);
                CvsCSID cs = CvsCSID.parse(csri.getChangeSetId());
                if (destcs != null && destcs.compareTo(cs) >= 0) continue;
                destcs = cs;
            }
            if (destcs != null && this.mDB.changesetContainsPath(destcs, ri.getPath())) {
                destcs = null;
            }
            if (destcs == null) {
                destcs = this.mDB.createNewChangeSetID(ri);
            }
            if (Logs.PERF_LOG.isDebugEnabled()) {
                Logs.PERF_LOG.debug((Object)(" " + destcs + " -> " + ri.getRevInfoKey()));
            }
            this.mDB.appendToChangeSet(destcs, Collections.singletonList(ri));
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private static class NextDateIterator {
        private final _Cu cu = _Cu.alloc();
        private final _ItemSpace db;
        private final int p1;

        public NextDateIterator(_ItemSpace db) {
            this.db = db;
            this.cu.append(RevInfoEAV.E_CSTODO_TO_REVID);
            this.p1 = this.cu.length();
        }

        public boolean hasNextDate() throws DbException {
            try {
                return this.db.next(this.cu, this.p1);
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }

        public long nextDate() {
            return this.cu.longAt(this.p1);
        }

        public TIntArrayList nextRevids() throws DbException {
            try {
                int p2 = this.cu.skipLong(this.p1);
                int p3 = this.cu.skipAttribute(p2);
                TIntArrayList result = new TIntArrayList();
                do {
                    int revid = (int)this.cu.longAt(p3);
                    result.add(revid);
                } while (this.db.next(this.cu, p2));
                return result;
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RevInfoPathComparator
    implements Comparator<CvsRevInfo> {
        public static final RevInfoPathComparator INSTANCE = new RevInfoPathComparator();

        private RevInfoPathComparator() {
        }

        @Override
        public int compare(CvsRevInfo a2, CvsRevInfo b2) {
            int cmp = a2.getPath().compareTo(b2.getPath());
            if (cmp != 0) {
                return 0;
            }
            cmp = a2.getCvsRevision().compareTo(b2.getCvsRevision());
            return cmp;
        }
    }
}

