/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.quicksearch;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.quicksearch.QuickSearchResults;
import com.cenqua.fisheye.cvsrep.quicksearch.QuickSearcher;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhraseQuickSearch
implements QuickSearcher.SearchAlgorithm {
    private final IndexReader reader;
    private final RepositoryEngine eng;
    private final String field;

    public PhraseQuickSearch(QuickSearcher searcher, String field, int idx) {
        this.reader = searcher.getReaders()[idx];
        this.eng = searcher.getEngine();
        this.field = field;
    }

    @Override
    public QuickSearchResults.TermResults search(Path path, List<String> params) throws IOException, DbException {
        if (params.isEmpty()) {
            return null;
        }
        QuickSearchResults.TermResults matches = new QuickSearchResults.TermResults();
        IndexSearcher searcher = new IndexSearcher(this.reader);
        PhraseQuery phraseQuery = new PhraseQuery();
        StringBuffer phraseQueryString = new StringBuffer();
        String phraseSep = "";
        for (String term : params) {
            phraseQuery.add(new Term(this.field, term));
            phraseQueryString.append(phraseSep).append(term);
            phraseSep = " ";
            BooleanQuery bq = CommonQuery3Helper.findRevisionsUnderDirQuery(path);
            bq.add((Query)new TermQuery(new Term(this.field, term)), BooleanClause.Occur.MUST);
            int count = LuceneHelper.countMatchingDocuments(searcher, (Query)bq, null);
            matches.addMatch(term, count);
        }
        if (matches.getResultCount() > 0) {
            BooleanQuery bq = CommonQuery3Helper.findRevisionsUnderDirQuery(path);
            bq.add((Query)phraseQuery, BooleanClause.Occur.MUST);
            int count = LuceneHelper.countMatchingDocuments(searcher, (Query)bq, null);
            matches.setUnionResultCount(count);
            matches.setUnionQueryString(phraseQueryString.toString());
        }
        return matches;
    }
}

