/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.search;

import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.obfuscate.idbk4ui8v._Attribute;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import gnu.trove.TIntArrayList;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class SimpleGrouper {
    private final _Attribute gattr;
    private final String type;

    protected SimpleGrouper(_Attribute gattr, String type) {
        this.gattr = gattr;
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Object[] group(_ItemSpace db, TIntArrayList revids) throws DbException {
        try {
            TIntArrayList l;
            LinkedHashMap<Serializable, TIntArrayList> groupMap = new LinkedHashMap<Serializable, TIntArrayList>();
            int revidsSize = revids.size();
            _Cu cu = _Cu.alloc();
            for (int i2 = 0; i2 < revidsSize; ++i2) {
                int revid = revids.get(i2);
                cu.clear().append(CommonSchema.RevInfo.ENTITY).append(revid).append(this.gattr);
                int pl = cu.length();
                Serializable g2 = db.next(cu, pl) ? this.getGroup(cu, pl) : null;
                l = (TIntArrayList)groupMap.get(g2);
                if (l == null) {
                    l = new TIntArrayList();
                    groupMap.put(g2, l);
                }
                l.add(revid);
            }
            Object[] groupStarts = new Object[revidsSize];
            int idx = 0;
            for (Map.Entry entry : groupMap.entrySet()) {
                groupStarts[idx] = entry.getKey();
                l = (TIntArrayList)entry.getValue();
                for (int j = 0; j < l.size(); ++j) {
                    revids.set(idx++, l.get(j));
                }
            }
            return groupStarts;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    protected abstract Serializable getGroup(_Cu var1, int var2);

    public static class LongAttributeGrouper
    extends SimpleGrouper {
        public LongAttributeGrouper(_Attribute gattr, String type) {
            super(gattr, type);
        }

        protected Long getGroup(_Cu cu, int pl) {
            return cu.longAt(pl);
        }
    }

    public static class StringAttributeGrouper
    extends SimpleGrouper {
        public StringAttributeGrouper(_Attribute gattr, String type) {
            super(gattr, type);
        }

        protected String getGroup(_Cu cu, int pl) {
            return cu.stringAt(pl);
        }
    }
}

