/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.search.query;

import com.cenqua.fisheye.cvsrep.search.query.Clause;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.search.ClauseVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class BoolClause
extends Clause {
    private final List<Clause> mSubClauses = new ArrayList<Clause>();
    private final boolean mRequired;

    public BoolClause(boolean required) {
        this.mRequired = required;
    }

    public void addClause(Clause c2) {
        this.mSubClauses.add(c2);
    }

    public boolean isRequired() {
        return this.mRequired;
    }

    public int getNumSubClases() {
        return this.mSubClauses.size();
    }

    public Iterator getSubClauses() {
        return this.mSubClauses.iterator();
    }

    public void accept(ClauseVisitor visitor) throws DbException, IOException {
        visitor.visitBoolClause(this);
    }

    public void toString(StringBuffer buf) {
        if (this.mSubClauses.size() != 1) {
            buf.append('(');
        }
        String spacer = this.getSeperator();
        String sep = "";
        for (Clause clause : this.mSubClauses) {
            buf.append(sep);
            clause.toString(buf);
            sep = spacer;
        }
        if (this.mSubClauses.size() != 1) {
            buf.append(')');
        }
    }

    protected abstract String getSeperator();
}

