/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.search.query;

import com.cenqua.fisheye.cvsrep.search.query.Clause;
import com.cenqua.fisheye.search.ClauseVisitor;
import java.io.IOException;

public class TaggedRangeClause
extends Clause {
    private boolean mStartInclusive;
    private boolean mEndInclusive;
    private String mStartTag;
    private String mEndTag;

    public void setStartInclusive(boolean startInclusive) {
        this.mStartInclusive = startInclusive;
    }

    public void setEndInclusive(boolean endInclusive) {
        this.mEndInclusive = endInclusive;
    }

    public void setStartTag(String startTag) {
        this.mStartTag = startTag;
    }

    public void setEndTag(String endTag) {
        this.mEndTag = endTag;
    }

    public void accept(ClauseVisitor visitor) throws IOException {
        visitor.visitTaggedRangeClause(this);
    }

    public boolean isStartInclusive() {
        return this.mStartInclusive;
    }

    public boolean isEndInclusive() {
        return this.mEndInclusive;
    }

    public String getStartTag() {
        return this.mStartTag;
    }

    public String getEndTag() {
        return this.mEndTag;
    }

    void toString(StringBuffer buf) {
        if (this.mEndTag == null) {
            buf.append("after tag ");
            TaggedRangeClause.quoteString(this.mStartTag, buf);
            return;
        }
        if (this.mStartTag == null) {
            buf.append("before tag ");
            TaggedRangeClause.quoteString(this.mEndTag, buf);
            return;
        }
        buf.append("between tags ");
        buf.append(this.mStartInclusive ? "[" : "(");
        TaggedRangeClause.quoteString(this.mStartTag, buf);
        buf.append(", ");
        TaggedRangeClause.quoteString(this.mEndTag, buf);
        buf.append(this.mEndInclusive ? "]" : ")");
    }
}

