/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff.view;

import com.cenqua.fisheye.diff.EDiff;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.diff.view.LinePair;
import com.cenqua.fisheye.diff.view.SectionView;
import com.cenqua.fisheye.logging.Logs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DiffPrinter {
    private final List sectionViews;
    private boolean sideBySide;
    private boolean softWrap;
    private List lineData;
    private boolean anySkippedSections = false;

    public DiffPrinter(List sectionViews, boolean sideBySide, boolean softWrap) {
        this.sectionViews = sectionViews;
        this.sideBySide = sideBySide;
        this.softWrap = softWrap;
    }

    public boolean isAnySkippedSections() {
        return this.anySkippedSections;
    }

    public void setAnySkippedSections(boolean anySkippedSections) {
        this.anySkippedSections = anySkippedSections;
    }

    public List getSectionViews() {
        return this.sectionViews;
    }

    public SectionView getFirstSectionView() {
        return (SectionView)this.sectionViews.get(0);
    }

    public SectionView getLastSectionView() {
        return (SectionView)this.sectionViews.get(this.sectionViews.size() - 1);
    }

    public boolean isSideBySide() {
        return this.sideBySide;
    }

    public boolean isUnified() {
        return !this.sideBySide;
    }

    public void setSideBySide(boolean sbs) {
        this.sideBySide = sbs;
        this.resetLinePairs();
    }

    private void resetLinePairs() {
        this.lineData = null;
    }

    private void precalcLinePairs() {
        if (this.lineData != null) {
            return;
        }
        this.lineData = new ArrayList();
        for (SectionView sv : this.sectionViews) {
            LineData lp;
            int lineOff;
            Section section = sv.getSection();
            boolean startOfSection = true;
            if (section.isCommonSubsequence() || this.sideBySide) {
                int maxLines = Math.max(section.getFromLength(), section.getToLength());
                for (int lineOff2 = 0; lineOff2 < maxLines; ++lineOff2) {
                    Integer fromLine = null;
                    Integer toLine = null;
                    if (lineOff2 < section.getFromLength()) {
                        fromLine = section.getFromStart() + lineOff2;
                    }
                    if (lineOff2 < section.getToLength()) {
                        toLine = section.getToStart() + lineOff2;
                    }
                    LineData lp2 = new LineData(sv, startOfSection, fromLine, toLine);
                    this.lineData.add(lp2);
                    startOfSection = false;
                }
                continue;
            }
            for (lineOff = 0; lineOff < section.getFromLength(); ++lineOff) {
                Integer fromLine = section.getFromStart() + lineOff;
                lp = new LineData(sv, startOfSection, fromLine, null);
                this.lineData.add(lp);
                startOfSection = false;
            }
            for (lineOff = 0; lineOff < section.getToLength(); ++lineOff) {
                Integer toLine = section.getToStart() + lineOff;
                lp = new LineData(sv, startOfSection, null, toLine);
                this.lineData.add(lp);
                startOfSection = false;
            }
        }
    }

    public Iterator getLinePairIterator() {
        this.precalcLinePairs();
        return new Iterator(){
            private int currentPairIndex = -1;
            public EDiff currentEdiff;

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.currentPairIndex + 1 < DiffPrinter.this.lineData.size();
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.currentPairIndex;
                LineData ld = (LineData)DiffPrinter.this.lineData.get(this.currentPairIndex);
                LinePair lp = new LinePair(DiffPrinter.this, ld.sectionView, ld.startOfSection, ld.fromLine, ld.toLine);
                if (lp.isStartOfSection()) {
                    this.currentEdiff = DiffPrinter.this.setupEdiff(lp.getSectionView());
                }
                lp.setEdiff(this.currentEdiff);
                return lp;
            }
        };
    }

    private EDiff setupEdiff(SectionView sv) {
        Section section = sv.getSection();
        if (section.isDiff() && section.getHunk().isChange()) {
            int sizeThres = 30;
            int closeThres = 10;
            int blockThresh = 10000;
            Hunk h2 = section.getHunk();
            int size = h2.getFromCount() + h2.getToCount();
            int close = Math.abs(h2.getFromCount() - h2.getToCount());
            if (size <= 30 && close <= 10) {
                CharSequence cs2;
                long t0 = System.currentTimeMillis();
                CharSequence cs1 = sv.getFromLines();
                EDiff ediff = new EDiff(cs1, cs2 = sv.getToLines());
                if (ediff.getTotalBlockLength() < 10000) {
                    ediff.doDiff();
                    long t1 = System.currentTimeMillis();
                    Logs.PERF_LOG.debug((Object)("ediff computed in " + (t1 - t0) + "ms"));
                    return ediff;
                }
            }
        }
        return null;
    }

    private static class LineData {
        SectionView sectionView;
        boolean startOfSection;
        Integer fromLine;
        Integer toLine;

        public LineData(SectionView sectionView, boolean startOfSection, Integer fromLine, Integer toLine) {
            this.sectionView = sectionView;
            this.startOfSection = startOfSection;
            this.fromLine = fromLine;
            this.toLine = toLine;
        }
    }
}

