/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.cenqua.fisheye.infinitydb.SimpleIndex;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.MinMaxLongRange;
import com.cenqua.obfuscate.idbk4ui8v._Attribute;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._EntityClass;
import com.cenqua.obfuscate.idbk4ui8v._Inversion;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import gnu.trove.TLongArrayList;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EavEntityCu {
    private final _ItemSpace db;
    private final _Cu cu;
    private final _Cu pkVal;
    private final int cuPkLen;

    public EavEntityCu(_ItemSpace db, _EntityClass entity, _Cu pk) {
        this.db = db;
        this.cu = _Cu.alloc().append(entity).append(pk);
        this.pkVal = _Cu.alloc(pk);
        this.cuPkLen = this.cu.length();
    }

    public EavEntityCu(_ItemSpace db, _EntityClass entity, long pk) {
        this(db, entity, _Cu.alloc().append(pk));
    }

    public _Cu getPk() {
        return _Cu.alloc(this.pkVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPK() throws IOException {
        try {
            if (!this.db.exists(this.cu)) {
                this.db.insert(this.cu);
            }
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValue(_Attribute attr, _Cu val) throws IOException {
        try {
            this.cu.append(attr);
            int pl = this.cu.length();
            this.cu.append(val);
            this.db.update(this.cu, pl);
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBoolean(_Attribute attr, boolean val) throws IOException {
        try {
            this.cu.append(attr);
            int pl = this.cu.length();
            this.cu.append(val);
            this.db.update(this.cu, pl);
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    public void updateInt(_Attribute attr, int val) throws IOException {
        this.updateLong(attr, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLong(_Attribute attr, long val) throws IOException {
        try {
            this.cu.append(attr);
            int pl = this.cu.length();
            this.cu.append(val);
            this.db.update(this.cu, pl);
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateString(_Attribute attr, String val) throws IOException {
        try {
            if (val == null) {
                this.deleteValues(attr);
            } else {
                this.cu.append(attr);
                int pl = this.cu.length();
                this.cu.append(val);
                this.db.update(this.cu, pl);
            }
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addString(_Attribute attr, String val) throws IOException {
        try {
            this.cu.append(attr);
            this.cu.append(val);
            this.db.insert(this.cu);
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLong(_Attribute attr, long val) throws IOException {
        try {
            this.cu.append(attr);
            this.cu.append(val);
            this.db.insert(this.cu);
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNoDupLong(_Attribute attr, long val) throws IOException {
        try {
            this.cu.append(attr);
            this.cu.append(val);
            if (!this.db.exists(this.cu)) {
                this.db.insert(this.cu);
            }
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMinMaxLongRange(_Attribute attr, MinMaxLongRange val) throws IOException {
        try {
            if (val == null) {
                this.deleteValues(attr);
            } else {
                this.cu.append(attr);
                int pl = this.cu.length();
                val.writeToCursor(this.cu);
                this.db.update(this.cu, pl);
            }
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    public int getInt(_Attribute attr, int defaultValue) throws IOException {
        return (int)this.getLong(attr, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(_Attribute attr, long defaultValue) throws IOException {
        try {
            this.cu.append(attr);
            int valueOffset = this.cu.length();
            long l = this.db.next(this.cu, valueOffset) ? this.cu.longAt(valueOffset) : defaultValue;
            return l;
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TLongArrayList getLongs(_Attribute attr) throws IOException {
        try {
            TLongArrayList result = new TLongArrayList();
            this.cu.append(attr);
            int valueOffset = this.cu.length();
            while (this.db.next(this.cu, valueOffset)) {
                result.add(this.cu.longAt(valueOffset));
            }
            TLongArrayList tLongArrayList = result;
            return tLongArrayList;
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(_Attribute attr, boolean defaultValue) throws IOException {
        try {
            this.cu.append(attr);
            int valueOffset = this.cu.length();
            boolean bl = this.db.next(this.cu, valueOffset) ? this.cu.booleanAt(valueOffset) : defaultValue;
            return bl;
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(_Attribute attr, String defaultValue) throws IOException {
        try {
            this.cu.append(attr);
            int valueOffset = this.cu.length();
            String string = this.db.next(this.cu, valueOffset) ? this.cu.stringAt(valueOffset) : defaultValue;
            return string;
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStrings(_Attribute attr) throws IOException {
        try {
            LinkedList<String> result = new LinkedList<String>();
            this.cu.append(attr);
            int valueOffset = this.cu.length();
            while (this.db.next(this.cu, valueOffset)) {
                result.add(this.cu.stringAt(valueOffset));
            }
            LinkedList<String> linkedList = result;
            return linkedList;
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStrings(_EntityClass stringTable, _Attribute attr) throws IOException, DbException {
        try {
            LinkedList<String> result = new LinkedList<String>();
            this.cu.append(attr);
            int valueOffset = this.cu.length();
            while (this.db.next(this.cu, valueOffset)) {
                long strid = this.cu.longAt(valueOffset);
                result.add(UniqueStringTable.get(this.db, stringTable, strid));
            }
            LinkedList<String> linkedList = result;
            return linkedList;
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getInts(_Attribute attr) throws IOException {
        try {
            LinkedList<Integer> result = new LinkedList<Integer>();
            this.cu.append(attr);
            int valueOffset = this.cu.length();
            while (this.db.next(this.cu, valueOffset)) {
                result.add((int)this.cu.longAt(valueOffset));
            }
            LinkedList<Integer> linkedList = result;
            return linkedList;
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MinMaxLongRange getMinMaxLongRange(_Attribute attr, MinMaxLongRange defaultValue) throws IOException {
        try {
            this.cu.append(attr);
            int off = this.cu.length();
            if (this.db.next(this.cu, off)) {
                MinMaxLongRange val = new MinMaxLongRange();
                val.readFromCursor(this.cu, off);
                MinMaxLongRange minMaxLongRange = val;
                return minMaxLongRange;
            }
            MinMaxLongRange minMaxLongRange = defaultValue;
            return minMaxLongRange;
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getValue(_Attribute att, _Cu result) throws IOException {
        try {
            this.cu.append(att);
            int offsetOfValue = this.cu.length();
            if (this.db.next(this.cu, offsetOfValue)) {
                result.append(this.cu, offsetOfValue);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() throws IOException {
        try {
            int offsetOfValue = this.cu.length();
            boolean bl = this.db.first(this.cu, offsetOfValue);
            return bl;
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteValues(_Attribute attr) throws IOException {
        try {
            this.cu.append(attr);
            int p1 = this.cu.length();
            while (this.db.first(this.cu, p1)) {
                this.db.delete(this.cu);
            }
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntity() throws IOException {
        try {
            int p1 = this.cu.length();
            while (this.db.first(this.cu, p1)) {
                this.db.delete(this.cu);
            }
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStringInversion(_Inversion inversion, String str) throws IOException {
        try {
            if (str == null) {
                inversion.clear(this.db, this.pkVal);
            } else {
                _Cu val = _Cu.alloc();
                val.append(str);
                inversion.update(this.db, this.pkVal, val);
            }
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValueIndex(SimpleIndex index, _Cu val) throws IOException {
        try {
            index.update(this.db, this.pkVal, val);
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStringIndex(SimpleIndex index, String str) throws IOException {
        try {
            if (str == null) {
                index.clear(this.db, this.pkVal);
            } else {
                _Cu val = _Cu.alloc();
                val.append(str);
                index.update(this.db, this.pkVal, val);
            }
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLongInversion(_Inversion inversion, long l) throws IOException {
        try {
            _Cu val = _Cu.alloc();
            val.append(l);
            inversion.update(this.db, this.pkVal, val);
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLongIndex(SimpleIndex inversion, long l) throws IOException {
        try {
            _Cu val = _Cu.alloc();
            val.append(l);
            inversion.update(this.db, this.pkVal, val);
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBooleanInversion(_Inversion inversion, boolean v) throws IOException {
        try {
            _Cu val = _Cu.alloc();
            val.append(v);
            inversion.update(this.db, this.pkVal, val);
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteInversion(_Inversion inversion) throws IOException {
        try {
            inversion.clear(this.db, this.pkVal);
        }
        finally {
            this.cu.setLength(this.cuPkLen);
        }
    }
}

