/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb.query3;

import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.obfuscate.idbk4ui8v._Attribute;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._EmptyItemSpace;
import com.cenqua.obfuscate.idbk4ui8v._EntityClass;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import com.cenqua.obfuscate.idbk4ui8v._ItemSubspace;
import gnu.trove.TIntHashSet;
import org.apache.lucene.index.IndexReader;

public class TermLookupQuery3
extends Query3 {
    private final _EntityClass entity;
    private final _EntityClass tableClass;
    private final String pk;
    private final _Attribute attr;

    public TermLookupQuery3(_EntityClass tableClass, _EntityClass entity, String pk, _Attribute attr) {
        this.entity = entity;
        this.tableClass = tableClass;
        this.pk = pk;
        this.attr = attr;
    }

    protected void calculateRequiredReaders(TIntHashSet requiredReaders) {
    }

    protected _ItemSpace asItemSpace(_ItemSpace source, IndexReader[] readers) throws DbException {
        long sid = UniqueStringTable.find(source, this.tableClass, this.pk);
        if (sid == -1L) {
            return new _EmptyItemSpace();
        }
        _Cu prefix = _Cu.alloc();
        prefix.append(this.entity);
        prefix.append(sid);
        if (this.attr != null) {
            prefix.append(this.attr);
        }
        return new _ItemSubspace(source, prefix);
    }

    public void toString(StringBuffer s) {
        s.append("TermLookup(").append(this.tableClass).append(" -> ");
        s.append(this.entity).append(", ").append(this.pk).append(", ").append(this.attr).append(")");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermLookupQuery3 that = (TermLookupQuery3)o;
        if (this.attr != null ? this.attr.getId() != that.attr.getId() : that.attr != null) {
            return false;
        }
        if (this.entity.getId() != that.entity.getId()) {
            return false;
        }
        if (!this.pk.equals(that.pk)) {
            return false;
        }
        return this.tableClass.getId() == that.tableClass.getId();
    }

    public int hashCode() {
        return this.pk.hashCode();
    }
}

