/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.license;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.license.CrucibleLicense;
import com.cenqua.fisheye.license.FishEyeLicense;
import com.cenqua.fisheye.license.LicenseException;
import com.cenqua.fisheye.util.StringUtil;
import java.io.File;
import java.util.Date;

public class LicenseInfo {
    private final FishEyeLicense feLicense;
    private final CrucibleLicense cruLicense;
    private final String renewMessage = "You can renew your license at <a href=\"http://www.atlassian.com/fisheye/renew\">http://www.atlassian.com/fisheye/renew</a>";
    private final int MAX_DAYS_BEFORE_RENEWAL_MESSAGE = 30;
    private static final double A_DAY = 8.64E7;

    public LicenseInfo(FishEyeLicense feLicense, CrucibleLicense cruLicense) {
        this.feLicense = feLicense;
        this.cruLicense = cruLicense;
    }

    public void validate(boolean isCrucible) throws LicenseException {
        if (isCrucible && this.cruLicense == null) {
            throw new LicenseException("You need a Crucible license to run Crucible.");
        }
        this.feLicense.validateForCurrentBuild();
        if (isCrucible) {
            this.cruLicense.validateForCurrentBuild();
            if (this.cruLicense.getSeats() == 0) {
                throw new LicenseException("Due to a change in the licencing mechanism, you will need to re-download your license from the Atlassian website.");
            }
        }
    }

    public String getProductName() {
        return this.cruLicense != null ? this.cruLicense.getProductName() : this.feLicense.getProductName();
    }

    public boolean isJspSourceEdition() {
        File index_jsp = new File(AppConfig.getAppHome(), "content/index.jsp");
        return index_jsp.isFile() && index_jsp.length() > 1L;
    }

    public FishEyeLicense getFisheyeLicense() {
        return this.feLicense;
    }

    public CrucibleLicense getCrucibleLicense() {
        return this.cruLicense;
    }

    public boolean isTerminated() {
        return this.feLicense.isTerminated() || this.cruLicense != null && this.cruLicense.isTerminated();
    }

    public boolean isExpired() {
        return this.feLicense.isExpired() || this.cruLicense != null && this.cruLicense.isExpired();
    }

    public boolean isMaintenanceExpired() {
        return this.feLicense.isMaintenanceExpired() || this.cruLicense != null && this.cruLicense.isMaintenanceExpired();
    }

    public boolean expires() {
        return this.feLicense.expires() || this.cruLicense != null && this.cruLicense.expires();
    }

    public boolean getExpires() {
        return this.expires();
    }

    public long getSoftExpiry() {
        long val = Long.MAX_VALUE;
        if (this.feLicense.expires()) {
            val = this.feLicense.getSoftExpiry();
        }
        if (this.cruLicense != null && this.cruLicense.expires()) {
            val = Math.min(val, this.cruLicense.getSoftExpiry());
        }
        return val == Long.MAX_VALUE ? 0L : val;
    }

    public String getRenewMessage() {
        return "You can renew your license at <a href=\"http://www.atlassian.com/fisheye/renew\">http://www.atlassian.com/fisheye/renew</a>";
    }

    public boolean getShowExpiryMessage() {
        return this.getDaysUntilMaintExpiry() <= 30;
    }

    public String getExpiryMessage() {
        String message;
        if (this.isMaintenanceExpired()) {
            message = "Your maintenance has expired.";
        } else {
            int days = this.getDaysUntilMaintExpiry();
            message = "You have " + StringUtil.pluralise(days, "day", "days") + " before your maintenance expires.";
        }
        return message;
    }

    public int getDaysUntilMaintExpiry() {
        long expiry = Long.MAX_VALUE;
        if (this.feLicense.maintenanceExpires()) {
            expiry = this.feLicense.getMaintExpiry();
        }
        if (this.cruLicense != null && this.cruLicense.maintenanceExpires()) {
            expiry = Math.min(expiry, this.cruLicense.getMaintExpiry());
        }
        return (int)Math.ceil((double)(expiry - System.currentTimeMillis()) / 8.64E7);
    }

    public long getHardExpiry() {
        long val = Long.MAX_VALUE;
        if (this.feLicense.expires()) {
            val = this.feLicense.getHardExpiry();
        }
        if (this.cruLicense != null && this.cruLicense.expires()) {
            val = Math.min(val, this.cruLicense.getHardExpiry());
        }
        return val == Long.MAX_VALUE ? 0L : val;
    }

    public Date getSoftExpiryValue() {
        return new Date(this.getSoftExpiry());
    }

    public Date getHardExpiryValue() {
        return new Date(this.getHardExpiry());
    }

    public String getOwnerStatement() {
        if (this.cruLicense != null && this.cruLicense.getShowOwnerInFooter()) {
            return this.cruLicense.getOwnerStatement();
        }
        return this.feLicense.getOwnerStatement();
    }

    public String getPublicID() {
        return this.feLicense.getPublicID();
    }

    public boolean getShowOwnerInFooter() {
        return this.feLicense.getShowOwnerInFooter() || this.cruLicense != null && this.cruLicense.getShowOwnerInFooter();
    }

    private Long getLatestBuildAllowed() throws LicenseException {
        Long b2;
        Long a2 = this.feLicense.getLatestBuildAllowed();
        Long l = b2 = this.cruLicense == null ? null : this.cruLicense.getLatestBuildAllowed();
        if (a2 == null) {
            return b2;
        }
        if (b2 == null) {
            return a2;
        }
        return Math.min(a2, b2);
    }

    public Date getLatestBuildAllowedValue() throws LicenseException {
        Long t = this.getLatestBuildAllowed();
        return t == null ? null : new Date(t);
    }

    public boolean getShouldHassle() {
        return this.feLicense.getShouldHassle() || this.cruLicense != null && this.cruLicense.getShouldHassle();
    }
}

