/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.logging;

import com.cenqua.fisheye.web.admin.actions.HtmlTesterLayout;
import com.cenqua.shaj.log.Log;
import com.cenqua.shaj.log.Log4Log;
import com.opensymphony.webwork.dispatcher.ServletDispatcher;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;

public class Logs {
    public static final org.apache.log4j.Logger ROOT = org.apache.log4j.Logger.getRootLogger();
    public static final org.apache.log4j.Logger PARENT = org.apache.log4j.Logger.getLogger((String)"fisheye");
    public static final org.apache.log4j.Logger APP_LOG = org.apache.log4j.Logger.getLogger((String)"fisheye.app");
    public static final org.apache.log4j.Logger CONSOLE = org.apache.log4j.Logger.getLogger((String)"fisheye.console");
    public static final org.apache.log4j.Logger DEBUG_LOG = org.apache.log4j.Logger.getLogger((String)"fisheye.debug");
    public static final org.apache.log4j.Logger PERF_LOG = org.apache.log4j.Logger.getLogger((String)"fisheye.perf");
    public static final org.apache.log4j.Logger MAIL_LOG = org.apache.log4j.Logger.getLogger((String)"fisheye.mail");
    public static final org.apache.log4j.Logger SVNKIT_LOG = org.apache.log4j.Logger.getLogger((String)"fisheye.svnkit");
    public static final org.apache.log4j.Logger CXF_LOG = org.apache.log4j.Logger.getLogger((String)"org.apache.cxf");
    public static final org.apache.log4j.Logger CRUC_NTF_LOG = org.apache.log4j.Logger.getLogger((String)"crucible.notification");
    private static final ConsoleAppender systemConsole = new ConsoleAppender((Layout)new SimpleLayout());
    private static int ANON_COUNTER = 1;

    public static void init() {
        org.apache.log4j.Logger.getLogger((String)ServletDispatcher.class.getName()).setLevel(org.apache.log4j.Level.ERROR);
        Log.Factory.setInstance((Log)new Log4Log(APP_LOG));
        ROOT.setLevel(org.apache.log4j.Level.WARN);
        systemConsole.setThreshold((Priority)org.apache.log4j.Level.WARN);
        APP_LOG.addAppender((Appender)systemConsole);
    }

    public static org.apache.log4j.Logger makeAnonymousLogger() {
        org.apache.log4j.Logger parent = org.apache.log4j.Logger.getLogger((String)"cenqua.debug");
        parent.setLevel(org.apache.log4j.Level.ALL);
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)("cenqua.debug." + ANON_COUNTER++));
        logger.setLevel(org.apache.log4j.Level.ALL);
        return logger;
    }

    public static Appender makeTestAppender(Writer writer, String ndc, Map style) {
        HtmlTesterLayout layout = new HtmlTesterLayout(style != null ? style : HtmlTesterLayout.getDefaultStyle(), ndc);
        WriterAppender appender = new WriterAppender((Layout)layout, writer);
        appender.setThreshold((Priority)org.apache.log4j.Level.ALL);
        appender.setImmediateFlush(true);
        return appender;
    }

    public static boolean isDebugMode() {
        return ROOT.getLevel() == org.apache.log4j.Level.INFO;
    }

    public static void setupQuietMode() {
        CONSOLE.setLevel(org.apache.log4j.Level.OFF);
        systemConsole.setThreshold((Priority)org.apache.log4j.Level.OFF);
    }

    public static void disableQuietMode() {
        CONSOLE.setLevel(org.apache.log4j.Level.WARN);
        systemConsole.setThreshold((Priority)org.apache.log4j.Level.WARN);
    }

    public static void setupDebugMode() {
        ROOT.setLevel(org.apache.log4j.Level.INFO);
        PARENT.setLevel(org.apache.log4j.Level.DEBUG);
        PERF_LOG.setLevel(org.apache.log4j.Level.DEBUG);
        Logs.setupSvnkitDebugLogging("javasvn");
        Logs.setupSvnkitDebugLogging("svnkit");
        systemConsole.setThreshold((Priority)org.apache.log4j.Level.DEBUG);
    }

    public static void disableDebugMode() {
        ROOT.setLevel(org.apache.log4j.Level.WARN);
        PARENT.setLevel(org.apache.log4j.Level.WARN);
        PERF_LOG.setLevel(org.apache.log4j.Level.WARN);
        Logs.disableSvnkitDebugLogging("javasvn");
        Logs.disableSvnkitDebugLogging("svnkit");
        systemConsole.setThreshold((Priority)org.apache.log4j.Level.WARN);
    }

    private static void setupSvnkitDebugLogging(String loggerName) {
        Logger svnkitLogger = Logger.getLogger(loggerName);
        if (svnkitLogger.getLevel() == null || svnkitLogger.getLevel().intValue() > Level.FINE.intValue()) {
            svnkitLogger.setLevel(Level.FINE);
        }
    }

    private static void disableSvnkitDebugLogging(String loggerName) {
        Logger svnkitLogger = Logger.getLogger(loggerName);
        svnkitLogger.setLevel(Level.WARNING);
    }

    public static class Warnings {
        public static boolean warnOnDupicatesInAttic = true;
        public static boolean warnOnDupicatesInAtticJustOnce = true;
        public static boolean warnMailerNotConfiguredJustOnce = true;
    }
}

