/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public abstract class AbstractBitsetQuery
extends Query {
    protected float score = 0.0f;

    public Similarity getSimilarity(Searcher searcher) {
        return Similarity.getDefault();
    }

    protected abstract BitSet computeBitset(IndexReader var1) throws IOException;

    protected abstract String getFilterExplanation();

    public Query rewrite(IndexReader reader) throws IOException {
        class SkipReaderBitsQuery
        extends Query {
            SkipReaderBitsQuery() {
            }

            public String toString(String field) {
                String res = "SkipReaderBitsQuery( " + AbstractBitsetQuery.this.getFilterExplanation() + ")";
                if (field == null) {
                    return res;
                }
                return res + "(" + field + " ?)";
            }

            protected Weight createWeight(final Searcher searcher) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class FilterWeight
                implements Weight {
                    FilterWeight() {
                    }

                    public float getValue() {
                        return 0.0f;
                    }

                    public void normalize(float norm) {
                    }

                    public float sumOfSquaredWeights() {
                        return 0.0f;
                    }

                    public Query getQuery() {
                        return AbstractBitsetQuery.this;
                    }

                    public Explanation explain(IndexReader reader, int doc) {
                        return new Explanation(this.getValue(), "weightless " + AbstractBitsetQuery.this.getFilterExplanation());
                    }

                    public Scorer scorer(final IndexReader reader) throws IOException {
                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        class SkipReaderBitsScorer
                        extends Scorer {
                            BitSet docNrs;
                            int currentDoc;

                            SkipReaderBitsScorer(Similarity similarity) throws IOException {
                                super(similarity);
                                this.docNrs = AbstractBitsetQuery.this.computeBitset(reader);
                                this.currentDoc = -1;
                            }

                            public int doc() {
                                return this.currentDoc;
                            }

                            public float score() {
                                return AbstractBitsetQuery.this.score;
                            }

                            public boolean next() {
                                this.currentDoc = this.docNrs.nextSetBit(this.currentDoc + 1);
                                return this.currentDoc >= 0;
                            }

                            public boolean skipTo(int target) {
                                this.currentDoc = this.docNrs.nextSetBit(this.currentDoc < target ? target : this.currentDoc + 1);
                                return this.currentDoc >= 0;
                            }

                            public Explanation explain(int doc) {
                                this.skipTo(doc);
                                return new Explanation(this.score(), "document " + doc + " " + (this.currentDoc == doc ? "matches" : "does not match") + " filter: " + AbstractBitsetQuery.this.getFilterExplanation());
                            }
                        }
                        return new SkipReaderBitsScorer(this.getSimilarity(searcher));
                    }
                }
                return new FilterWeight();
            }
        }
        return new SkipReaderBitsQuery();
    }
}

