/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene.join;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.join.RightJoinEnum;
import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

public class LeftJoin {
    private final String leftField;
    private final RightJoinEnum rightEnum;

    public LeftJoin(String leftField, RightJoinEnum rightEnum) {
        this.leftField = leftField;
        this.rightEnum = rightEnum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitSet computeResult(IndexReader leftReader) throws IOException {
        long t0 = System.currentTimeMillis();
        this.rightEnum.reset();
        TermDocs leftTD = leftReader.termDocs();
        try {
            BitSet bs = new BitSet(leftReader.maxDoc());
            while (this.rightEnum.hasNext()) {
                leftTD.seek(new Term(this.leftField, this.rightEnum.term().text()));
                while (leftTD.next()) {
                    bs.set(leftTD.doc());
                }
            }
            long t1 = System.currentTimeMillis();
            if (Logs.PERF_LOG.isDebugEnabled()) {
                Logs.PERF_LOG.debug((Object)("left join on " + this.rightEnum.describe() + " in " + (t1 - t0) + "ms"));
            }
            BitSet bitSet = bs;
            return bitSet;
        }
        finally {
            leftTD.close();
            this.rightEnum.close();
        }
    }
}

