/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.PathNotFoundException;
import com.cenqua.fisheye.cache.RecentChangesParams;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4FileHistory;
import com.cenqua.fisheye.perforce.P4RepositoryInfo;
import com.cenqua.fisheye.perforce.client.AnnotateCallBack;
import com.cenqua.fisheye.perforce.client.P4Client;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4ClientFactory;
import com.cenqua.fisheye.perforce.client.P4Job;
import com.cenqua.fisheye.perforce.client.P4Process;
import com.cenqua.fisheye.perforce.client.P4Visitor;
import com.cenqua.fisheye.perforce.db.P4RevInfo;
import com.cenqua.fisheye.perforce.db.P4RevInfoDAO;
import com.cenqua.fisheye.perforce.db.P4StringTables;
import com.cenqua.fisheye.perforce.search.P4RecentChangesSearcher;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryCache;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.SortedMapFileHistory;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.util.SortedMultiMap;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4Cache
extends RepositoryCache {
    private final P4RepositoryInfo repositoryInfo;
    private Charset charset;
    private GenericObjectPool clientPool;
    private P4StringTables p4StringTables;

    public P4Cache(P4RepositoryInfo repInfo) {
        this.repositoryInfo = repInfo;
    }

    @Override
    public void start() throws IOException, DbException {
        super.start();
        this.p4StringTables = new P4StringTables(this.getInfDb());
    }

    @Override
    public RevInfoKey getKey(int revid) throws DbException {
        return this.createDAO().getKey(revid);
    }

    public P4RevInfoDAO createDAO() {
        return new P4RevInfoDAO(this.getInfDb(), this.p4StringTables, this.getCommonStringTables(), this.repositoryInfo.isCaseSensitive());
    }

    @Override
    public boolean isCaseSensitive() {
        return this.repositoryInfo.isCaseSensitive();
    }

    @Override
    public boolean showAuthorLinecount() {
        return this.repositoryInfo.isStoreDiffs();
    }

    @Override
    public CommonRevInfoDAO getCommonRevInfoDAO() throws DbException {
        return this.createDAO().getCommonRevInfoDAO();
    }

    @Override
    public boolean isFile(Path path) throws DbException {
        P4RevInfoDAO dao = this.createDAO();
        int revid = dao.getLatestPathRevid(path);
        return revid != -1 && dao.getFileType(revid) == 1;
    }

    @Override
    public void getTextRevision(RevInfoKey key, final OutputStream out, String kopt, String symrev) throws IOException, DbException {
        P4Client client = this.allocateClient();
        try {
            long changeListId = Long.parseLong(key.getRev());
            String filePath = this.repositoryInfo.getServerPath(key.getPath(), changeListId);
            client.streamContent(filePath, changeListId, null, new P4Visitor.ProcessOutputVisitor(){

                public void visit(P4Process p4Process, InputStream is) throws P4Visitor.VisitorException {
                    try {
                        IOHelper.copyStream(is, out);
                    }
                    catch (IOException e2) {
                        throw new P4Visitor.VisitorException(e2);
                    }
                    finally {
                        IOHelper.close(is);
                    }
                }
            });
        }
        catch (RepositoryClientException e2) {
            Logs.APP_LOG.error((Object)("Exception loading P4 content for " + key), (Throwable)e2);
            throw new DbException("P4 Client exception fetching content: " + e2.getMessage(), e2);
        }
        finally {
            this.returnClient(client);
        }
    }

    public void getTextRevision(RevInfoKey key, OutputStream out, String kopt) throws IOException, DbException {
        this.getTextRevision(key, out, kopt, null);
    }

    private P4Client allocateClient() throws DbException {
        try {
            return (P4Client)this.clientPool.borrowObject();
        }
        catch (Exception e2) {
            throw new DbException("Unable to allocate an P4 client for " + this.repositoryInfo.getServer(), e2);
        }
    }

    public void returnClient(P4Client client) {
        if (client != null) {
            try {
                this.clientPool.returnObject((Object)client);
            }
            catch (Exception e2) {
                Logs.APP_LOG.error((Object)"Exception returning client instance", (Throwable)e2);
            }
        }
    }

    @Override
    public void getBinaryRevision(RevInfoKey key, final OutputStream out) throws IOException, DbException {
        P4Client client = this.allocateClient();
        try {
            long changeListId = Long.parseLong(key.getRev());
            String filePath = this.repositoryInfo.getServerPath(key.getPath(), changeListId);
            client.streamContent(filePath, changeListId, null, new P4Visitor.ProcessOutputVisitor(){

                public void visit(P4Process p4Process, InputStream is) throws P4Visitor.VisitorException {
                    try {
                        IOHelper.copyStream(is, out);
                    }
                    catch (IOException e2) {
                        throw new P4Visitor.VisitorException(e2);
                    }
                    finally {
                        IOHelper.close(is);
                    }
                }
            });
        }
        catch (P4ClientException e2) {
            Logs.APP_LOG.error((Object)("Exception loading P4 content for " + key), (Throwable)e2);
            throw new DbException("P4 Client exception fetching content: " + e2.getMessage(), e2);
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public Charset getTextEncoding(RevInfoKey rkey) throws DbException {
        P4RevInfo revInfo = (P4RevInfo)this.getFileRevision(rkey);
        Charset result = revInfo.isUnicode() ? (this.repositoryInfo.isUnicode() ? Charset.forName("UTF-8") : Charset.forName("UTF-16")) : this.charset;
        return result;
    }

    @Override
    public FileRevision getFileRevision(int revid) throws DbException {
        return this.createDAO().load(revid);
    }

    @Override
    public FileRevision getFileRevision(RevInfoKey rkey) throws DbException {
        P4RevInfoDAO dao = this.createDAO();
        int revid = dao.getRevId(rkey.getPath(), Long.parseLong(rkey.getRev()));
        return dao.load(revid);
    }

    @Override
    public ChangeSet getChangeSet(String csid) throws DbException {
        long rev;
        try {
            rev = Long.parseLong(csid);
        }
        catch (NumberFormatException e2) {
            return null;
        }
        return this.createDAO().loadChangeSet(rev);
    }

    @Override
    public String getChangeSetId(RevInfoKey rk) throws DbException {
        return rk.getRev();
    }

    @Override
    public List<String> findRecentChangeSetIds(RecentChangesParams params) throws DbException {
        P4RevInfoDAO dao = this.createDAO();
        P4RecentChangesSearcher rcSearcher = new P4RecentChangesSearcher(this.getLuceneConnection(), (_ItemSpace)this.getInfDb().get(), params, dao, this.isCaseSensitive());
        try {
            return rcSearcher.findRecentChangeSets();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public List<ChangeSet> findRecentChangeSets(RecentChangesParams params) throws DbException {
        List<String> ids = this.findRecentChangeSetIds(params);
        ArrayList<ChangeSet> results = new ArrayList<ChangeSet>();
        for (String id : ids) {
            ChangeSet cs = this.getChangeSet(id);
            if (cs == null) continue;
            results.add(cs);
        }
        return results;
    }

    @Override
    public FileHistory getFileHistory(Path path, boolean physicalOnly) throws DbException {
        P4RevInfoDAO dao = this.createDAO();
        SortedMap<Long, Integer> csids = dao.getPathRevisions(path);
        SortedMultiMap<Long, P4RevInfo> history = new SortedMultiMap<Long, P4RevInfo>();
        for (Map.Entry<Long, Integer> entry : csids.entrySet()) {
            Long csid = entry.getKey();
            Integer revid = entry.getValue();
            P4RevInfo revision = dao.load(revid);
            history.add(csid, revision);
        }
        return new P4FileHistory(path, history);
    }

    @Override
    public FileHistory getFullFileHistory(Path path, boolean physicalOnly) throws DbException {
        if (physicalOnly) {
            return this.getFileHistory(path);
        }
        SortedMultiMap ancestry = new SortedMultiMap();
        long latestCsid = this.createDAO().getLatestPathChange(path);
        RevInfoKey key = new RevInfoKey(path, Long.toString(latestCsid));
        SortedMapFileHistory.addFileAncestry(this, ancestry, key, true, false);
        return new P4FileHistory(path, ancestry);
    }

    @Override
    public Blame getBlame(RevInfoKey revInfoKey) throws DbException, IOException {
        FileRevision revision = this.getFileHistory(revInfoKey.getPath()).getRevision(revInfoKey.getRev());
        if (revision == null) {
            throw new PathNotFoundException("File not found", revInfoKey);
        }
        if (!revision.isAnnotatable()) {
            throw new PathNotFoundException("File is not annotatable", revInfoKey);
        }
        P4Client client = this.allocateClient();
        try {
            long changeListId = Long.parseLong(revInfoKey.getRev());
            String fileSpec = this.repositoryInfo.getServerPath(revInfoKey.getPath(), changeListId);
            final ArrayList<Blame.BlameChunk> chunks = new ArrayList<Blame.BlameChunk>();
            final FileHistory history = this.getFullFileHistory(revInfoKey.getPath());
            final FileRevision firstRev = history.getRevision(history.getHead());
            AnnotateCallBack callback = new AnnotateCallBack(){
                private int lineNum = 0;
                long currentRev = -1L;
                Blame.BlameChunk currentChunk = null;

                public void singleLine(long revision, String line) {
                    if (this.currentRev == revision && this.currentChunk.getLength() < 8000) {
                        this.currentChunk.incLength(1);
                    } else {
                        FileRevision fileRev = history.getRevision(Long.toString(revision));
                        if (fileRev == null) {
                            P4RevInfo placeHolder = new P4RevInfo();
                            placeHolder.setRevision(Long.toString(revision));
                            if (firstRev != null) {
                                placeHolder.setDate(firstRev.getDate());
                            }
                            fileRev = placeHolder;
                        }
                        this.currentRev = revision;
                        this.currentChunk = new Blame.BlameChunk(fileRev, this.lineNum, this.lineNum);
                        chunks.add(this.currentChunk);
                    }
                    ++this.lineNum;
                }
            };
            P4RevInfo revInfo = (P4RevInfo)revision;
            client.getBlame(fileSpec, changeListId, revInfo.isUnicode(), callback);
            Blame blame = new Blame(chunks);
            return blame;
        }
        catch (RepositoryClientException e2) {
            Logs.APP_LOG.error((Object)("Exception getting annotation for " + revInfoKey), (Throwable)e2);
            throw new IOException("Exception getting annotation blame: " + e2.getMessage());
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public List<String> getSimilarChangeSetIds(String id) throws DbException {
        return Collections.emptyList();
    }

    @Override
    public List<String> findSimilarPartialChangeSetIds(String partialId) throws DbException {
        return Collections.emptyList();
    }

    @Override
    public String getRepositoryType() {
        return "p4";
    }

    @Override
    public String getImpliedBranch(Path path) {
        return null;
    }

    @Override
    public AndQuery3 findRevisionsUnderDirQuery3(Path dir, boolean findLogical) {
        return CommonQuery3Helper.findRevisionsUnderDirQuery3(dir, this.repositoryInfo.isCaseSensitive());
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setClientFactory(P4ClientFactory clientFactory) {
        this.clientPool = new GenericObjectPool((PoolableObjectFactory)clientFactory);
        this.clientPool.setMaxActive(50);
        this.clientPool.setMaxIdle(3);
        this.clientPool.setWhenExhaustedAction((byte)1);
        this.clientPool.setMaxWait(20000L);
    }

    public long getJobId(String jobName) throws DbException {
        return this.createDAO().findJobId(jobName);
    }

    public P4Job getJob(String jobName) throws DbException {
        return this.createDAO().loadJob(jobName);
    }
}

