/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.P4RepType;
import com.cenqua.fisheye.config1.RepositoryDefaultsType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.UserPassAuthType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4RepoTester;
import com.cenqua.fisheye.perforce.P4RepositoryEngine;
import com.cenqua.fisheye.perforce.P4RepositoryInfo;
import com.cenqua.fisheye.perforce.client.P4Client;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.NetworkRepositorySettings;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryTester;
import com.cenqua.fisheye.util.Interval;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.util.Throttle;
import java.nio.charset.Charset;

public class P4RepositoryConfig
extends RepositoryConfig {
    public static final Charset DEFAULT_ENCODING;
    private final String server;
    private final int port;
    private final String path;
    private static final int DEFAULT_P4_PORT = 1666;
    private final boolean isUnicode;
    private final Charset charset;
    private final long blocksize;
    private final boolean caseSensitive;
    private final int maxFilelogs;
    private final String commandTimeout;
    private final NetworkRepositorySettings networkSettings;

    public P4RepositoryConfig(RepositoryType config, RepositoryDefaultsType configDefaults) throws ConfigException {
        super(config, configDefaults);
        P4RepType p4E = config.getPerforce();
        this.server = p4E.getServer();
        this.port = p4E.isSetPort() ? p4E.getPort().intValue() : 1666;
        this.path = p4E.getPath();
        if (p4E.isSetUnicode()) {
            this.isUnicode = p4E.getUnicode();
            this.charset = Charset.forName("UTF-8");
        } else if (p4E.isSetCharset()) {
            this.isUnicode = false;
            String cs = p4E.getCharset();
            try {
                this.charset = Charset.forName(cs);
            }
            catch (IllegalArgumentException e2) {
                throw new ConfigException("Not a valid encoding name: '" + cs + "'. Valid names are " + Charset.availableCharsets().keySet(), e2);
            }
        } else {
            this.isUnicode = false;
            this.charset = DEFAULT_ENCODING;
        }
        this.blocksize = p4E.isSetBlocksize() ? p4E.getBlocksize().longValue() : 200L;
        String pollPeriod = p4E.isSetUpdater() ? p4E.getUpdater().getPollPeriod() : null;
        UserPassAuthType auth = p4E.isSetAuth() ? p4E.getAuth() : null;
        float cpsLimit = p4E.isSetCps() ? p4E.getCps() : 0.0f;
        this.networkSettings = new NetworkRepositorySettings(auth, pollPeriod, cpsLimit);
        this.caseSensitive = p4E.isSetCasesensitive() ? p4E.getCasesensitive() : true;
        this.maxFilelogs = p4E.isSetFileloglimit() ? p4E.getFileloglimit().intValue() : -1;
        this.commandTimeout = p4E.isSetCommandTimeout() && !StringUtil.nullOrEmpty(p4E.getCommandTimeout().trim()) ? p4E.getCommandTimeout() : null;
    }

    public RepositoryEngine createRepositoryEngine() throws ConfigException, DbException {
        return new P4RepositoryEngine(this);
    }

    public RepositoryTester createRepositoryTester() throws ConfigException {
        P4Client client;
        try {
            client = new P4Client(this.createRespositoryInfo(), new Throttle());
        }
        catch (P4ClientException e2) {
            throw new ConfigException(e2);
        }
        return new P4RepoTester(client);
    }

    public P4RepositoryInfo createRespositoryInfo() {
        P4RepositoryInfo repoInfo = new P4RepositoryInfo();
        repoInfo.setAllowRules(this.getAllowRules());
        repoInfo.setServer(this.getServer());
        repoInfo.setPort(this.getPort());
        repoInfo.setBasePath(this.getPath());
        repoInfo.setContentIndexingEnabled(this.isContentIndexingEnabled());
        repoInfo.setUsername(this.networkSettings.getUsername());
        repoInfo.setPassword(this.networkSettings.getPassword());
        repoInfo.setUnicode(this.isUnicodeServer());
        repoInfo.setCaseSensitive(this.isCaseSensitive());
        repoInfo.setStoreDiffs(this.isStoreDiffs());
        repoInfo.setMaxFilelogs(this.maxFilelogs);
        if (this.commandTimeout != null) {
            try {
                Interval commandTimeoutInterval = new Interval(this.commandTimeout);
                repoInfo.setCommandTimeout(commandTimeoutInterval.getValueInMillis());
            }
            catch (NumberFormatException e2) {
                Logs.APP_LOG.error((Object)("Command timeout interval is not valid: " + this.commandTimeout));
            }
        }
        return repoInfo;
    }

    public NetworkRepositorySettings getNetworkSettings() {
        return this.networkSettings;
    }

    public String getServer() {
        return this.server;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isUnicodeServer() {
        return this.isUnicode;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public long getBlocksize() {
        return this.blocksize;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    static {
        String defaultEncoding = System.getProperty("file.encoding");
        DEFAULT_ENCODING = Charset.forName(defaultEncoding);
    }
}

