/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import com.cenqua.fisheye.perforce.P4InputPump;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4OutputPump;
import com.cenqua.fisheye.util.LatchedRunnable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class P4Process {
    private Process p4Process;
    private StringBuilder errorString = new StringBuilder();
    private Throwable processException;
    private long lastOutputTime;
    private long timeout;
    private String[] cmdArray;
    private String input;
    private String encoding;
    private LatchedRunnable outputPump;
    private LatchedRunnable errorPump;
    private LatchedRunnable inputPump;
    private static final ExecutorService pumpThreadPool;

    public P4Process(String[] cmdArray, String input, long timeout, String encoding) {
        this.cmdArray = cmdArray;
        this.timeout = timeout;
        this.input = input;
        this.encoding = encoding;
    }

    protected abstract void processOutput(InputStream var1) throws IOException, P4ClientException;

    protected void resetWatchdog() {
        this.lastOutputTime = System.currentTimeMillis();
    }

    private long getTimeoutTime() {
        return this.lastOutputTime + this.timeout;
    }

    private boolean isTimedOut() {
        long now = System.currentTimeMillis();
        return this.getTimeoutTime() < now;
    }

    private boolean pumpsRunning() {
        return this.outputPump.isRunning() || this.errorPump.isRunning() || this.inputPump != null && this.inputPump.isRunning();
    }

    public void start() throws P4ClientException {
        try {
            this.p4Process = Runtime.getRuntime().exec(this.cmdArray);
        }
        catch (IOException e2) {
            throw new P4ClientException(e2);
        }
        this.setupIOPumps();
    }

    /*
     * Exception decompiling
     */
    public String finish() throws P4ClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String complete(String exitStatus) throws P4ClientException {
        return exitStatus;
    }

    private void setupIOPumps() {
        if (this.input != null) {
            this.inputPump = new P4InputPump(this.p4Process.getOutputStream(), this.input, this.encoding);
        }
        this.errorPump = new P4OutputPump(this.p4Process.getErrorStream(), this.errorString, this.encoding);
        this.outputPump = new LatchedRunnable(){

            protected void doTask() {
                try {
                    P4Process.this.processOutput(P4Process.this.p4Process.getInputStream());
                }
                catch (Throwable e2) {
                    P4Process.this.processException = e2;
                }
            }
        };
        this.resetWatchdog();
        pumpThreadPool.execute(this.errorPump);
        pumpThreadPool.execute(this.outputPump);
        if (this.inputPump != null) {
            pumpThreadPool.execute(this.inputPump);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int finishProcess() throws P4ClientException {
        do {
            long checkTime = this.getTimeoutTime();
            this.awaitPump(this.outputPump, checkTime);
            this.awaitPump(this.inputPump, checkTime);
            this.awaitPump(this.errorPump, checkTime);
        } while (!this.isTimedOut() && this.pumpsRunning());
        int exitCode = -1;
        boolean destroyProcess = true;
        try {
            exitCode = this.p4Process.exitValue();
            destroyProcess = false;
        }
        catch (IllegalThreadStateException e2) {
            while (destroyProcess && System.currentTimeMillis() - this.getTimeoutTime() < 10L) {
                try {
                    Thread.sleep(100L);
                    exitCode = this.p4Process.exitValue();
                    destroyProcess = false;
                }
                catch (InterruptedException e1) {
                }
                catch (IllegalThreadStateException e22) {}
            }
        }
        finally {
            if (destroyProcess) {
                this.p4Process.destroy();
            }
        }
        this.awaitPump(this.outputPump, 10000L);
        this.awaitPump(this.inputPump, 10000L);
        this.awaitPump(this.errorPump, 10000L);
        if (destroyProcess) {
            throw new P4ClientException("P4 command failed to complete");
        }
        return exitCode;
    }

    private void awaitPump(LatchedRunnable runnable, long latestTime) {
        if (runnable != null) {
            long timeout = latestTime - System.currentTimeMillis();
            if (timeout < 1L) {
                timeout = 1L;
            }
            runnable.await(timeout);
        }
    }

    public void cancel() {
        if (this.outputPump != null) {
            this.outputPump.interrupt();
        }
        if (this.inputPump != null) {
            this.inputPump.interrupt();
        }
        if (this.errorPump != null) {
            this.errorPump.interrupt();
        }
    }

    static {
        ThreadFactory threadFactory = new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread(r, "P4 IO Pump");
            }
        };
        pumpThreadPool = new ThreadPoolExecutor(3, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }
}

