/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileRevision {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_FILE = 1;
    public static final int TYPE_DIR = 2;

    public abstract String getRevision();

    public abstract String getAncestorRevision();

    public abstract RevInfoKey getDiffRevision();

    public abstract AncestorLink getAncestorLink();

    public abstract Path getPath();

    public abstract String getComment();

    public abstract String getAuthor();

    public abstract long getDate();

    public abstract long getDateEnd();

    public abstract List<String> getBranches();

    public abstract List<String> getTags();

    public abstract int getRevID();

    public abstract String getBranch();

    public abstract boolean isTrunkLike();

    public abstract boolean isBinary();

    public abstract boolean isDead();

    public abstract boolean isAdded();

    public abstract boolean isCopy();

    public abstract boolean isMove();

    public abstract boolean isModify();

    public abstract int getLinesAdded();

    public abstract int getLinesRemoved();

    public abstract int getLineCount();

    public abstract Date getDateValue();

    public String getChangeSetId() {
        return this.getRevision();
    }

    public abstract RevInfoKey getRevInfoKey();

    public abstract RevInfoKey getCopySource();

    public abstract List<RevInfoKey> getCopyDestinations() throws DbException;

    public abstract RevInfoKey getMoveSource();

    public abstract RevInfoKey getMoveDestination() throws DbException;

    public abstract int getFileType();

    public boolean isFile() {
        return this.getFileType() == 1;
    }

    public boolean isDir() {
        return this.getFileType() == 2;
    }

    public boolean isAnnotatable() {
        return !this.isBinary();
    }

    public abstract List<Integer> getReviewIds();

    public abstract List<Hunk> getHunks();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OldestFirstComparator
    implements Comparator<FileRevision> {
        public static final OldestFirstComparator INSTANCE = new OldestFirstComparator();

        @Override
        public int compare(FileRevision a2, FileRevision b2) {
            long bDate;
            long aDate = a2.getDate();
            if (aDate < (bDate = b2.getDate())) {
                return -1;
            }
            if (aDate > bDate) {
                return 1;
            }
            return a2.getRevision().compareTo(b2.getRevision());
        }
    }
}

