/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class IndexSchema {
    public static final int DEFAULT_IDX = 0;
    private static final BitSet SINGLE_DEFAULT_INDEX = new BitSet();
    private final Map fieldIndexMap = new HashMap();
    private final BitSet allIndexes = new BitSet();

    public void addFieldsForIndex(int idx, String[] fields) {
        for (int i2 = 0; i2 < fields.length; ++i2) {
            this.addIndexForField(fields[i2], idx);
        }
    }

    public void addIndexForField(String field, int idx) {
        BitSet bs = (BitSet)this.fieldIndexMap.get(field);
        if (bs == null) {
            bs = new BitSet();
            this.fieldIndexMap.put(field, bs);
        }
        bs.set(idx);
        this.allIndexes.set(idx);
    }

    public BitSet getIndexesForField(String field) {
        if (this.fieldIndexMap.containsKey(field)) {
            return (BitSet)this.fieldIndexMap.get(field);
        }
        return SINGLE_DEFAULT_INDEX;
    }

    public int getFirstIndexForField(String field) {
        return this.getIndexesForField(field).nextSetBit(0);
    }

    public String getJoinField() {
        return "revid";
    }

    public BitSet getAllIndexes() {
        return this.allIndexes;
    }

    static {
        SINGLE_DEFAULT_INDEX.set(0);
    }
}

