/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.UserPassAuthType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.Interval;

public class NetworkRepositorySettings {
    public static final long DEFAULT_POLL_PERIOD = 60000L;
    private final String username;
    private final String password;
    private final float cps;
    private final long pollPeriod;
    private static final String NEVER = "Never";

    public NetworkRepositorySettings(UserPassAuthType auth, String pollPeriodString, float cps) throws ConfigException {
        if (auth != null) {
            this.username = auth.getUsername();
            this.password = auth.getPassword();
        } else {
            this.username = null;
            this.password = null;
        }
        long periodValue = 60000L;
        if (pollPeriodString != null) {
            try {
                if (pollPeriodString.equalsIgnoreCase(NEVER)) {
                    periodValue = 0L;
                } else {
                    Interval period = new Interval(pollPeriodString);
                    periodValue = period.getValueInMillis();
                }
            }
            catch (NumberFormatException ex) {
                Logs.APP_LOG.warn((Object)("could not parse pollPeriod: " + ex.getMessage()));
            }
        }
        this.pollPeriod = periodValue;
        this.cps = cps;
        if (cps < 0.0f) {
            throw new ConfigException("The Connections Per Second setting may not be negative");
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public long getPollPeriod() {
        return this.pollPeriod;
    }

    public float getCps() {
        return this.cps;
    }
}

