/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.crucible.fisheye.CrucibleReindexMessage;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.hibernate.TxHelper;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonUtilDAO;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._EntityClass;
import com.cenqua.obfuscate.idbk4ui8v._k4ui8vIDB;
import java.io.IOException;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;

public class ReviewInfoDAO {
    private static final int CACHE_VER = 1;
    private final String[] closedStates = StateManager.INSTANCE.getClosedStateNames();
    private final String[] openStates = StateManager.INSTANCE.getOpenStateNames();
    private final String[] draftStates = StateManager.INSTANCE.getDraftStateNames();
    private final InfinityDbHandle dbh;
    private final CommonRevInfoDAO rdao;
    private final String repname;
    private final CommonUtilDAO util;
    private final RepositoryStatus status;

    public ReviewInfoDAO(InfinityDbHandle dbh, CommonRevInfoDAO rdao, String repname, RepositoryStatus status) {
        this.dbh = dbh;
        this.rdao = rdao;
        this.repname = repname;
        this.status = status;
        this.util = new CommonUtilDAO(dbh, rdao.getStringTables());
    }

    public boolean slurp(boolean reindex) throws DbException {
        TxHelper txHelper = new TxHelper();
        try {
            Session session = null;
            try {
                session = HibernateUtil.currentSession();
            }
            catch (HibernateException e2) {
                Logs.APP_LOG.info((Object)"Could not get session, skipping slurp", (Throwable)e2);
            }
            boolean result = false;
            if (session != null) {
                txHelper.beginTx();
                result = this.doSlurp(session, reindex);
                txHelper.commitTx();
            }
            this.status.setMessage(null);
            boolean bl = result;
            return bl;
        }
        catch (HibernateException e3) {
            throw new DbException(e3);
        }
        finally {
            try {
                this.dbh.rollback();
            }
            catch (IOException e4) {
                throw new DbException(e4);
            }
            txHelper.rollbackTxIfNotCommited();
            txHelper.closeSession();
        }
    }

    private boolean doSlurp(Session session, boolean requestReindex) throws DbException {
        try {
            boolean updated;
            boolean reindex;
            long ver = this.util.getLongProperty("cru.version", -1L);
            boolean bl = reindex = ver != 1L || requestReindex;
            if (reindex) {
                this.util.setLongProperty("cru.version", 1L);
                updated = true;
                if (ver != -1L) {
                    this.blowaway();
                }
                this.doFullscan(session);
            } else {
                updated = this.doIncremental(session);
            }
            this.dbh.commit();
            return updated;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private boolean doIncremental(Session session) throws DbException {
        try {
            Timer timer = new Timer("Review incremental scan for " + this.repname);
            Query q = session.createQuery("from CrucibleReindexMessage fru where fru.fileRevision.sourceName = :sourceName order by fru.id asc");
            q.setString("sourceName", Source.getRepoSourceName(this.repname));
            _Cu cu = _Cu.alloc();
            int count = 0;
            for (CrucibleReindexMessage update : q.list()) {
                if (count == 0) {
                    this.status.setMessage("Indexing review data.");
                }
                this.processRevision(cu, update.getReview(), update.getFileRevision());
                session.delete((Object)update);
                ++count;
            }
            Logs.PERF_LOG.debug((Object)("indexed " + count + " revision updates."));
            timer.end();
            return count != 0;
        }
        catch (HibernateException e2) {
            throw new DbException(e2);
        }
    }

    private void doFullscan(Session session) throws DbException {
        try {
            this.status.setMessage("Indexing all review data.");
            Timer timer = new Timer("Review fullscan for " + this.repname);
            this.deleteOldMessages(session);
            Query q = session.createQuery("select frx.frr.fileRevision.spr.path,    frx.frr.fileRevision.spr.revIdent,    frx.review.id, frx.review.stateName from FileRevisionExtraInfo frx where frx.frr.fileRevision.spr.sourceName = :sourceName");
            q.setString("sourceName", Source.getRepoSourceName(this.repname));
            int count = 0;
            _Cu cu = _Cu.alloc();
            for (Object[] row : q.list()) {
                String path = (String)row[0];
                String revision = (String)row[1];
                Integer review = (Integer)row[2];
                String state = (String)row[3];
                RevInfoKey rik = new RevInfoKey(new Path(path), revision);
                int revid = this.rdao.getRevId(rik);
                if (revid == -1) continue;
                this.addRevisionToReview(cu, revid, review, state);
                if (++count % 100 != 0) continue;
                this.status.setMessage("Indexing all review data, " + count + " rows so far.");
            }
            Logs.PERF_LOG.debug((Object)("indexed " + count + " Crucible rows."));
            timer.end();
        }
        catch (HibernateException e2) {
            throw new DbException(e2);
        }
    }

    private void deleteOldMessages(Session session) {
        Query delExisting = session.createQuery("delete CrucibleReindexMessage where fileRevision in (from FileRevision fr where fr.spr.sourceName = :sourceName)");
        delExisting.setString("sourceName", Source.getRepoSourceName(this.repname));
        int nDeleted = delExisting.executeUpdate();
        Logs.PERF_LOG.debug((Object)("deleted " + nDeleted + " old index messages"));
    }

    private void blowaway() throws DbException {
        this.status.setMessage("Removing old review index.");
        try {
            _Cu cu = _Cu.alloc();
            _k4ui8vIDB db = this.dbh.get();
            cu.clear().append(CommonSchema.E_CLOSEDREVIEW_REVIDS);
            db.deleteSubspace(cu);
            cu.clear().append(CommonSchema.E_OPENREVIEW_REVIDS);
            db.deleteSubspace(cu);
            cu.clear().append(CommonSchema.E_DRAFTREVIEW_REVIDS);
            db.deleteSubspace(cu);
            cu.clear().append(CommonSchema.E_REVIEW_TO_REVID);
            db.deleteSubspace(cu);
            this.rdao.deleteAttribteOnAllRevisions(CommonSchema.RevInfo.A_REVIEWIDS);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void addRevisionToReview(_Cu cu, int revid, int reviewid, String reviewState) throws DbException {
        try {
            State state = StateManager.INSTANCE.getStateByName(reviewState);
            _EntityClass metastate = null;
            if (state.isClosedMetaState()) {
                metastate = CommonSchema.E_CLOSEDREVIEW_REVIDS;
            } else if (state.isOpenMetaState()) {
                metastate = CommonSchema.E_OPENREVIEW_REVIDS;
            } else if (state.isDraftMetaState()) {
                metastate = CommonSchema.E_DRAFTREVIEW_REVIDS;
            }
            _k4ui8vIDB db = this.dbh.get();
            if (metastate != null) {
                cu.clear().append(metastate).append(revid);
                db.insert(cu);
            }
            cu.clear().append(CommonSchema.E_REVIEW_TO_REVID).append(reviewid).append(revid);
            db.insert(cu);
            cu.clear().append(CommonSchema.E_REVINFO).append(revid).append(CommonSchema.RevInfo.A_REVIEWIDS).append(reviewid);
            db.insert(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void processRevision(_Cu cu, Review review, FileRevision fr) throws DbException {
        try {
            RevInfoKey rk = fr.getRevInfoKey();
            int revid = this.rdao.getRevId(rk);
            if (revid == -1) {
                Logs.APP_LOG.warn((Object)("could not find revision " + rk));
                return;
            }
            int reviewid = review.getId();
            boolean inReview = FRXManager.getFRExtraInfo(fr, review) != null;
            int nClosed = ReviewManager.countReviewsInStateContainingFileRevision(this.closedStates, fr);
            int nOpen = ReviewManager.countReviewsInStateContainingFileRevision(this.openStates, fr);
            int nDraft = ReviewManager.countReviewsInStateContainingFileRevision(this.draftStates, fr);
            _k4ui8vIDB db = this.dbh.get();
            cu.clear().append(CommonSchema.E_REVIEW_TO_REVID).append(reviewid).append(revid);
            this.insertOrDelete(db, cu, inReview);
            cu.clear().append(CommonSchema.E_REVINFO).append(revid).append(CommonSchema.RevInfo.A_REVIEWIDS).append(reviewid);
            this.insertOrDelete(db, cu, inReview);
            cu.clear().append(CommonSchema.E_CLOSEDREVIEW_REVIDS).append(revid);
            this.insertOrDelete(db, cu, nClosed > 0);
            cu.clear().append(CommonSchema.E_OPENREVIEW_REVIDS).append(revid);
            this.insertOrDelete(db, cu, nOpen > 0);
            cu.clear().append(CommonSchema.E_DRAFTREVIEW_REVIDS).append(revid);
            this.insertOrDelete(db, cu, nDraft > 0);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void insertOrDelete(_k4ui8vIDB db, _Cu cu, boolean insert) throws IOException {
        if (insert) {
            db.insert(cu);
        } else {
            db.delete(cu);
        }
    }
}

