/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search;

import com.cenqua.crucible.model.PermaIdFormatException;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.search.AbstractBeforeAfterQuery3;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._EmptyItemSpace;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import com.cenqua.obfuscate.idbk4ui8v._ItemSubspace;
import com.cenqua.obfuscate.idbk4ui8v._OrSpace;
import java.util.EnumSet;
import org.hibernate.HibernateException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewQuery3
extends AbstractBeforeAfterQuery3 {
    private final String permaid;
    private final EnumSet<StateManager.MetaState> metaStates;

    public ReviewQuery3(String permaid, EnumSet<StateManager.MetaState> metaStates, boolean inclusive, boolean after, boolean before) {
        super(inclusive, after, before);
        this.permaid = permaid;
        this.metaStates = metaStates;
    }

    @Override
    protected _ItemSpace getInputRevids(_ItemSpace db) throws DbException {
        if (this.permaid != null) {
            return this.getReviewSpace(db);
        }
        if (this.metaStates != null) {
            return this.getReviewStatesSpace(db);
        }
        return new _EmptyItemSpace();
    }

    private _ItemSpace getReviewStatesSpace(_ItemSpace db) {
        _OrSpace any = new _OrSpace();
        if (this.metaStates.contains((Object)StateManager.MetaState.CLOSED)) {
            any.add(new _ItemSubspace(db, _Cu.alloc().append(CommonSchema.E_CLOSEDREVIEW_REVIDS)));
        }
        if (this.metaStates.contains((Object)StateManager.MetaState.OPEN)) {
            any.add(new _ItemSubspace(db, _Cu.alloc().append(CommonSchema.E_OPENREVIEW_REVIDS)));
        }
        if (this.metaStates.contains((Object)StateManager.MetaState.DRAFT)) {
            any.add(new _ItemSubspace(db, _Cu.alloc().append(CommonSchema.E_DRAFTREVIEW_REVIDS)));
        }
        return any;
    }

    private _ItemSpace getReviewSpace(_ItemSpace db) throws DbException {
        Review review = null;
        try {
            review = ReviewManager.getReviewByPermaId(this.permaid);
        }
        catch (HibernateException e2) {
            throw new DbException(e2);
        }
        catch (PermaIdFormatException e3) {
            Logs.APP_LOG.warn((Object)"Query contained an invalid permaid", (Throwable)e3);
        }
        if (review == null) {
            return new _EmptyItemSpace();
        }
        _Cu prefix = _Cu.alloc();
        int reviewId = review.getId();
        prefix.append(CommonSchema.E_REVIEW_TO_REVID).append(reviewId);
        return new _ItemSubspace(db, prefix);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReviewQuery3 that = (ReviewQuery3)o;
        if (!this.abstractEquals(that)) {
            return false;
        }
        if (this.metaStates != null ? !this.metaStates.equals(that.metaStates) : that.metaStates != null) {
            return false;
        }
        return !(this.permaid != null ? !this.permaid.equals(that.permaid) : that.permaid != null);
    }

    @Override
    public int hashCode() {
        int result = this.permaid != null ? this.permaid.hashCode() : 0;
        result = 31 * result + (this.metaStates != null ? this.metaStates.hashCode() : 0);
        return result;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append("Review(");
        if (this.permaid != null) {
            s.append("permaid=").append(this.permaid).append(",");
        }
        if (this.metaStates != null) {
            s.append("metaStates=").append(this.metaStates).append(",");
        }
        s.append("after=").append(this.after).append(",");
        s.append("inclusive=").append(this.inclusive).append(",");
        s.append("before=").append(this.before).append(")");
        s.append(")");
    }
}

