/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.util.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Info;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.Revision;

public class RepositoryWalker {
    private static final FilenameFilter svnFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return !name.equals(".svn");
        }
    };
    private SvnRepositoryInfo repositoryInfo;
    private SvnThrottledClient client;
    private long revision;
    private Revision rev;
    private boolean skipTags;

    public RepositoryWalker(SvnRepositoryInfo repositoryInfo, SvnThrottledClient client, long revision) {
        this.repositoryInfo = repositoryInfo;
        this.client = client;
        this.revision = revision;
        this.rev = new Revision.Number(revision);
    }

    public void setSkipTags(boolean skipTags) {
        this.skipTags = skipTags;
    }

    public void walkDir(Path localPath, Visitor visitor) throws RepositoryClientException, IOException, DbException {
        if (!this.repositoryInfo.isPathInRepo(localPath)) {
            return;
        }
        Logs.APP_LOG.debug((Object)("Walking dir " + localPath));
        String dirURL = this.repositoryInfo.getPathURL(localPath, this.revision);
        Logs.APP_LOG.debug((Object)("Getting info for " + dirURL + "@" + this.rev));
        Info2[] infos = this.client.info2(dirURL, this.rev, this.rev, false);
        Info2 info = infos[0];
        boolean continueWalk = visitor.visitRemoteEntry(this.client, localPath, this.revision, info);
        if (continueWalk && info.getKind() == 2) {
            Path dummyPath = new Path(localPath, "dummy_entry");
            String containerType = this.repositoryInfo.getPathMatcher().getContainerId(dummyPath);
            Logs.APP_LOG.debug((Object)("Container type for " + localPath + " is " + containerType));
            if (containerType.startsWith("trunk:")) {
                Logs.APP_LOG.debug((Object)("Walking trunk checkout " + localPath));
                this.checkOutAndWalk(localPath, visitor);
            } else if (containerType.startsWith("branch:")) {
                Logs.APP_LOG.debug((Object)("Walking branches dir " + localPath));
                this.walkBranchesDir(localPath, visitor);
            } else if (containerType.startsWith("tag:")) {
                if (!this.skipTags) {
                    Logs.APP_LOG.debug((Object)("Walking tags dir " + localPath));
                    this.walkTagsDir(localPath, visitor);
                }
            } else if (this.repositoryInfo.getPathMatcher().isEmpty()) {
                Logs.APP_LOG.debug((Object)("Walking checkout " + localPath));
                this.checkOutAndWalk(localPath, visitor);
            } else {
                Logs.APP_LOG.debug((Object)("Walking root " + localPath));
                this.walkRoot(localPath, visitor);
            }
        }
    }

    private boolean walkRoot(Path rootPath, Visitor visitor) throws RepositoryClientException, IOException, DbException {
        return this.walkRemote(rootPath, visitor);
    }

    private boolean walkRemote(Path rootPath, Visitor visitor) throws RepositoryClientException, IOException, DbException {
        DirEntry[] rootItems;
        String dirURL = this.repositoryInfo.getPathURL(rootPath, this.revision);
        for (DirEntry item : rootItems = this.client.list(dirURL, this.rev, this.rev, false)) {
            Path itemPath = new Path(rootPath, item.getPath());
            if (item.getNodeKind() == 2) {
                this.walkDir(itemPath, visitor);
                continue;
            }
            Logs.APP_LOG.debug((Object)("Processing remote entry " + itemPath));
            Info2[] infos = this.client.info2(this.repositoryInfo.getPathURL(itemPath, this.revision), this.rev, this.rev, false);
            boolean continueWalk = visitor.visitRemoteEntry(this.client, itemPath, this.revision, infos[0]);
            if (continueWalk) continue;
            return false;
        }
        return true;
    }

    private void walkTagsDir(Path tagsDirPath, Visitor visitor) throws RepositoryClientException, IOException, DbException {
        DirEntry[] tagRoots;
        String dirURL = this.repositoryInfo.getPathURL(tagsDirPath, this.revision);
        for (DirEntry tagRoot : tagRoots = this.client.list(dirURL, this.rev, this.rev, false)) {
            Info2[] infos;
            Path tagRootPath = new Path(tagsDirPath, tagRoot.getPath());
            boolean continueWalk = visitor.visitRemoteEntry(this.client, tagRootPath, this.revision, (infos = this.client.info2(this.repositoryInfo.getPathURL(tagRootPath, this.revision), this.rev, this.rev, false))[0]);
            if (!continueWalk || tagRoot.getNodeKind() != 2) continue;
            this.checkOutAndWalk(tagRootPath, visitor);
        }
    }

    private void walkBranchesDir(Path branchesDirPath, Visitor visitor) throws RepositoryClientException, IOException, DbException {
        DirEntry[] branchRoots;
        String dirURL = this.repositoryInfo.getPathURL(branchesDirPath, this.revision);
        for (DirEntry branchRoot : branchRoots = this.client.list(dirURL, this.rev, this.rev, false)) {
            Info2[] infos;
            Path branchRootPath = new Path(branchesDirPath, branchRoot.getPath());
            boolean continueWalk = visitor.visitRemoteEntry(this.client, branchRootPath, this.revision, (infos = this.client.info2(this.repositoryInfo.getPathURL(branchRootPath, this.revision), this.rev, this.rev, false))[0]);
            if (!continueWalk || branchRoot.getNodeKind() != 2) continue;
            this.checkOutAndWalk(branchRootPath, visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOutAndWalk(Path dirPath, Visitor visitor) throws RepositoryClientException, IOException, DbException {
        File checkoutDir = null;
        try {
            String pathURL = this.repositoryInfo.getPathURL(dirPath, this.revision);
            checkoutDir = File.createTempFile("FEImport", null, this.repositoryInfo.getRepoTempDir());
            checkoutDir.delete();
            checkoutDir.mkdirs();
            Logs.APP_LOG.debug((Object)("Checking out " + pathURL));
            this.client.checkout(pathURL, checkoutDir.getAbsolutePath(), this.rev, this.rev, true, true);
            this.visitLocalCheckout(checkoutDir, visitor);
        }
        catch (Throwable throwable) {
            FileUtils.deleteTree(checkoutDir);
            throw throwable;
        }
        FileUtils.deleteTree(checkoutDir);
    }

    private void visitLocalCheckout(File dir, Visitor visitor) throws RepositoryClientException, IOException, DbException {
        File[] files;
        Logs.APP_LOG.debug((Object)("Visiting checked out dir " + dir));
        for (File file : files = dir.listFiles(svnFilter)) {
            boolean continueWalk;
            if (file.getName().equals(".svn")) {
                Logs.APP_LOG.debug((Object)"Found a .svn file which should have been excluded");
                continue;
            }
            Info fileInfo = this.client.info(file.getAbsolutePath());
            if (file.exists()) {
                Logs.APP_LOG.debug((Object)("Visiting working copy entry " + file));
                continueWalk = visitor.visitWorkingCopyEntry(this.client, file, fileInfo, this.revision);
            } else {
                String path = fileInfo.getUrl().substring(fileInfo.getRepository().length());
                Path localPath = this.repositoryInfo.getLocalPath(path, this.revision);
                Info2[] infos = this.client.info2(fileInfo.getUrl(), this.rev, this.rev, false);
                continueWalk = infos.length != 0 ? visitor.visitRemoteEntry(this.client, localPath, this.revision, infos[0]) : true;
            }
            if (!continueWalk || !file.isDirectory()) continue;
            this.visitLocalCheckout(file, visitor);
        }
    }

    public static interface Visitor {
        public boolean visitRemoteEntry(SvnThrottledClient var1, Path var2, long var3, Info2 var5) throws RepositoryClientException, IOException, DbException;

        public boolean visitWorkingCopyEntry(SvnThrottledClient var1, File var2, Info var3, long var4) throws RepositoryClientException, IOException, DbException;
    }
}

