/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.NetworkRepositorySettings;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RepositoryTester;
import com.cenqua.fisheye.svn.SvnPasswordSupplier;
import com.cenqua.fisheye.svn.SvnRepositoryConfig;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.util.MD5;
import com.cenqua.fisheye.util.Throttle;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNClient;
import org.tigris.subversion.javahl.SVNClientInterface;

public class SvnRepositoryTester
extends RepositoryTester {
    private final SvnThrottledClient svnClient;
    private final SvnRepositoryInfo repInfo;
    private final String accessKey;

    public SvnRepositoryTester(SvnRepositoryConfig config) {
        this.repInfo = new SvnRepositoryInfo();
        this.repInfo.setRepositoryName(config.getName());
        this.repInfo.setRepositoryLocation(config.getRepoUrl().trim(), config.getRepoPath());
        NetworkRepositorySettings networkSettings = config.getNetworkSettings();
        SvnPasswordSupplier passwordSupplier = new SvnPasswordSupplier(networkSettings.getUsername(), networkSettings.getPassword());
        Throttle throttle = new Throttle();
        SVNClient client = new SVNClient();
        client.setPrompt((PromptUserPassword)passwordSupplier);
        this.svnClient = new SvnThrottledClient("testing", throttle, (SVNClientInterface)client, 300000L);
        this.accessKey = config.getAccessKey();
    }

    public SvnRepositoryTester(SvnThrottledClient svnClient, SvnRepositoryInfo repInfo, String accessKey) {
        this.svnClient = svnClient;
        this.repInfo = repInfo;
        this.accessKey = accessKey;
    }

    public void testConnection() throws ConfigException {
        RepositoryStatus status = new RepositoryStatus();
        this.checkRepoSettings();
        this.pingAndValidateAccess(this.repInfo.getRepositoryRoot(-1L), status);
    }

    public void checkRepoSettings() throws ConfigException {
        try {
            Logs.APP_LOG.debug((Object)("Checking repository:  " + this.repInfo.getRepositoryDescriptor()));
            String rootURL = this.getServerRootURL(this.svnClient);
            if (!rootURL.equalsIgnoreCase(this.repInfo.getRepositoryURL())) {
                Logs.APP_LOG.warn((Object)("Repository URL " + this.repInfo.getRepositoryURL() + " does not match URL returned from repository: " + rootURL));
            }
        }
        catch (RepositoryClientException e2) {
            throw new ConfigException("Unable to get repository information: " + e2.getMessage(), e2);
        }
    }

    public String getServerRootURL(SvnThrottledClient svnClient) throws RepositoryClientException {
        DirEntry[] dirEntries;
        Info2[] info = svnClient.info2(this.repInfo.getRepositoryRoot(-1L), Revision.HEAD, Revision.HEAD, false);
        if (info.length == 0 && (dirEntries = svnClient.list(this.repInfo.getRepositoryRoot(-1L), Revision.HEAD, Revision.HEAD, false)).length != 0) {
            String entryURL = this.repInfo.getPathURL(this.repInfo.getLocalPath(dirEntries[0].getPath(), -1L), -1L);
            info = svnClient.info2(entryURL, Revision.HEAD, Revision.HEAD, false);
        }
        if (info.length == 0) {
            throw new RepositoryClientException("Unable to get Repository Root URL for " + this.repInfo.getRepositoryDescriptor());
        }
        String rootURL = info[0].getReposRootUrl();
        return rootURL;
    }

    void pingAndValidateAccess(String repoPath, RepositoryStatus statusReporter) throws ConfigException {
        String accessData;
        try {
            Logs.APP_LOG.debug((Object)("Validating access to " + repoPath));
            PropertyData feAccess = this.svnClient.propertyGet(repoPath, "fisheye.access", Revision.HEAD, Revision.HEAD);
            if (feAccess != null) {
                accessData = feAccess.getValue();
                Logs.APP_LOG.debug((Object)("FishEye Access property found [" + accessData + "]"));
            } else {
                Logs.APP_LOG.debug((Object)"FishEye Access property is null");
                accessData = null;
            }
        }
        catch (Exception e2) {
            statusReporter.setMessage("Could not access " + repoPath);
            Logs.APP_LOG.error((Object)"Exception getting FishEye access control", (Throwable)e2);
            throw new ConfigException("Could not access " + repoPath + " : " + e2.getMessage(), e2);
        }
        if (!this.isAccessGranted(accessData)) {
            statusReporter.setMessage("Unable to scan repository as it is not configured for remote FishEye access");
            throw new ConfigException("The repository " + repoPath + " is not configured for remote FishEye access." + " It needs a " + "fisheye.access" + " property, see the documentation.");
        }
    }

    private boolean isAccessGranted(String accessData) {
        if (accessData == null) {
            return true;
        }
        String serverAccessKey = accessData.trim();
        if (serverAccessKey.equals("allow")) {
            return true;
        }
        if (serverAccessKey.equals("deny")) {
            return false;
        }
        if (serverAccessKey.toLowerCase().startsWith("md5:") && this.accessKey != null) {
            String serverHash = serverAccessKey.substring("md5:".length());
            String computedHash = MD5.hash(this.accessKey);
            if (computedHash.equalsIgnoreCase(serverHash)) {
                return true;
            }
            Logs.APP_LOG.warn((Object)"Access denied by server - hash mismatch");
        }
        return false;
    }
}

