/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.diff;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.LineReader;
import com.cenqua.fisheye.io.ReaderLineReader;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.svn.RepositoryWalker;
import com.cenqua.fisheye.svn.SvnAction;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.svn.diff.ChangeInfo;
import com.cenqua.fisheye.svn.diff.DiffListener;
import com.cenqua.fisheye.svn.diff.MessageInfo;
import com.cenqua.fisheye.svn.diff.SvnDiffException;
import com.cenqua.fisheye.svn.diff.SvnDiffParser;
import com.cenqua.fisheye.svn.diff.SvnDiffParsingException;
import com.cenqua.fisheye.svn.util.ChangePathUtil;
import com.cenqua.fisheye.svn.util.SvnURLDecoder;
import com.cenqua.fisheye.util.LineCountingInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.Info;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffProcessor {
    private final RepositoryStatus statusReporter;
    private final SvnRepositoryInfo repositoryInfo;
    private final SvnThrottledClient client;
    private SvnDiffParser diffParser;
    private DiffListener listener = new DiffListener();
    private String savedStatus;
    private String ourStatus;
    private File exportDir;

    public DiffProcessor(SvnRepositoryInfo repInfo, SvnThrottledClient client, RepositoryStatus status) {
        this.repositoryInfo = repInfo;
        this.client = client;
        this.statusReporter = status;
        this.diffParser = new SvnDiffParser(repInfo.getLocale());
        this.exportDir = new File(repInfo.getRepoTempDir(), "export");
        this.exportDir.mkdirs();
    }

    private void doDiff(String path, long startRev, long endRev, File diffFile, boolean recurse) throws RepositoryClientException {
        Revision.Number startRevision = new Revision.Number(startRev);
        Revision.Number endRevision = new Revision.Number(endRev);
        this.client.diff(path, (Revision)endRevision, (Revision)startRevision, (Revision)endRevision, diffFile.getAbsolutePath(), recurse, true, true, false);
    }

    private void setStatusMessage(String message) {
        this.resetStatusMessage();
        this.savedStatus = this.statusReporter.getMessage();
        this.ourStatus = message;
        this.statusReporter.setMessage(message);
    }

    private void resetStatusMessage() {
        if (this.ourStatus != null) {
            String current = this.statusReporter.getMessage();
            if (current.equals(this.ourStatus)) {
                this.statusReporter.setMessage(this.savedStatus);
            }
            this.ourStatus = null;
        }
    }

    private void processPathSet(MessageInfo messageInfo, Set<Path> diffRootSet, List<ChangePath> requiredPaths) throws RepositoryClientException, SvnDiffParsingException, IOException {
        if (this.statusReporter.isStopRequested()) {
            return;
        }
        long rev = messageInfo.getRevisionNumber();
        for (Path diffRootPath : diffRootSet) {
            this.setStatusMessage("Fetching combined diff for " + diffRootPath + " in revision " + rev + " in " + this.repositoryInfo.getRepositoryDescriptor());
            ReaderLineReader reader = null;
            File diffFile = null;
            boolean retainDiff = false;
            try {
                diffFile = File.createTempFile("FESVNW_", "", this.repositoryInfo.getRepoTempDir());
                long startRev = rev - 1L;
                ChangePath changePath = messageInfo.getChangePath(diffRootPath);
                this.doDiff(this.repositoryInfo.getPathURL(diffRootPath, rev), startRev, rev, diffFile, true);
                FileInputStream fis = new FileInputStream(diffFile);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, this.repositoryInfo.getDefaultCharset());
                reader = new ReaderLineReader(LineReader.Mode.MODE_MIXED, new BufferedReader(isr));
                this.diffParser.setContextPath(diffRootPath);
                this.diffParser.setContext(diffFile, rev);
                this.diffParser.process(reader, this.listener);
            }
            catch (SvnDiffParsingException e2) {
                try {
                    Logs.APP_LOG.error((Object)("Unable to parse diff - retaining " + diffFile.getAbsolutePath()));
                    if (Logs.APP_LOG.isDebugEnabled()) {
                        retainDiff = true;
                    }
                    throw e2;
                }
                catch (Throwable throwable) {
                    IOHelper.close(reader);
                    if (!retainDiff && diffFile != null) {
                        diffFile.delete();
                    }
                    throw throwable;
                }
            }
            IOHelper.close(reader);
            if (!retainDiff && diffFile != null) {
                diffFile.delete();
            }
            Iterator<ChangePath> i2 = requiredPaths.iterator();
            while (i2.hasNext()) {
                ChangePath changePath = i2.next();
                Path path = messageInfo.getLocalPath(changePath);
                if (!this.listener.getChangeInfos().containsKey(path)) continue;
                i2.remove();
            }
        }
    }

    private void confirmNodeTypes(LogMessage message, MessageInfo messageInfo) {
        ChangePath[] changePaths;
        Map<Path, ChangeInfo> changeInfos = messageInfo.getChangeInfos();
        for (ChangePath changePath : changePaths = message.getChangedPaths()) {
            Path physicalPath;
            ChangeInfo changeInfo;
            if (changePath.getCopySrcPath() != null || !this.repositoryInfo.isPathInRepo(changePath.getPath(), message.getRevisionNumber()) || (changeInfo = changeInfos.get(physicalPath = messageInfo.getLocalPath(changePath))) != null && changeInfo.isFileDiff() || SvnAction.isDeleteAction(changePath.getAction())) continue;
            try {
                Info2 info;
                if (changeInfo == null) {
                    changeInfo = new ChangeInfo();
                    changeInfos.put(physicalPath, changeInfo);
                }
                if ((info = messageInfo.getInfo(this.client, physicalPath)) == null) continue;
                changeInfo.setFileDiff(info.getKind() == 1);
            }
            catch (RepositoryClientException e2) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChangePaths(MessageInfo messageInfo, List<ChangePath> paths, List<ChangePath> copiedPaths) throws RepositoryClientException, IOException, SvnDiffParsingException {
        if (paths.isEmpty()) {
            return;
        }
        File diffFile = null;
        try {
            diffFile = File.createTempFile("FESVNS_", "", this.repositoryInfo.getRepoTempDir());
            int count = 0;
            for (ChangePath changePath : paths) {
                ++count;
                if (this.statusReporter.isStopRequested()) {
                    return;
                }
                this.setStatusMessage("Fetching info " + count + " of " + paths.size() + " for revision " + messageInfo.getRevisionNumber());
                this.processChangePath(messageInfo, copiedPaths, diffFile, changePath);
            }
        }
        finally {
            if (diffFile != null && diffFile.exists()) {
                diffFile.delete();
            }
        }
    }

    private void processChangePath(MessageInfo messageInfo, List<ChangePath> copiedPaths, File diffFile, ChangePath changePath) throws RepositoryClientException, IOException, SvnDiffParsingException {
        Path physicalPath = messageInfo.getLocalPath(changePath);
        String url = this.repositoryInfo.getPathURL(physicalPath, messageInfo.getRevisionNumber());
        Revision.Number revNumber = new Revision.Number(messageInfo.getRevisionNumber());
        Info2 info = messageInfo.getInfo(this.client, physicalPath);
        if (info != null && info.getKind() == 1) {
            if (SvnAction.isAddAction(changePath.getAction()) || copiedPaths.contains(changePath)) {
                this.addNewFileChangeInfo(messageInfo, physicalPath);
            } else {
                this.processChangePathDiff(messageInfo, diffFile, physicalPath, url);
            }
        } else {
            PropertyData[] props = this.client.properties(url, (Revision)revNumber, (Revision)revNumber);
            ChangeInfo changeInfo = new ChangeInfo();
            messageInfo.setChangeInfo(physicalPath, changeInfo);
            this.setPropertyInfo(props, changeInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChangePathDiff(MessageInfo messageInfo, File diffFile, Path physicalPath, String url) throws RepositoryClientException, SvnDiffParsingException, IOException {
        ReaderLineReader reader = null;
        try {
            boolean previousOk;
            try {
                messageInfo.getInfo(this.client, physicalPath, messageInfo.getRevisionNumber() - 1L);
                previousOk = true;
            }
            catch (RepositoryClientException e2) {
                previousOk = false;
            }
            if (previousOk) {
                long rev = messageInfo.getRevisionNumber();
                this.doDiff(url, rev - 1L, rev, diffFile, false);
                FileInputStream fis = new FileInputStream(diffFile);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, this.repositoryInfo.getDefaultCharset());
                reader = new ReaderLineReader(LineReader.Mode.MODE_MIXED, new BufferedReader(isr));
                this.diffParser.setContext(diffFile, messageInfo.getRevisionNumber());
                this.diffParser.setContextPath(physicalPath.getParent());
                this.diffParser.process(reader, this.listener);
                reader.close();
                reader = null;
                diffFile.delete();
            } else {
                this.addNewFileChangeInfo(messageInfo, physicalPath);
            }
        }
        finally {
            IOHelper.close(reader);
        }
    }

    public MessageInfo processMessage(LogMessage message) throws SvnDiffException {
        try {
            Logs.APP_LOG.debug((Object)("Processing message " + message.getRevisionNumber() + " in " + this.repositoryInfo.getRepositoryDescriptor()));
            MessageInfo messageInfo = new MessageInfo(this.repositoryInfo, message);
            ChangePath[] changePaths = message.getChangedPaths();
            if (changePaths != null) {
                List<ChangePath> excludedDiffs = this.getExcludedPaths(messageInfo, changePaths);
                ArrayList<ChangePath> diffsRequired = new ArrayList<ChangePath>();
                ArrayList<ChangePath> newDirs = new ArrayList<ChangePath>();
                ArrayList<ChangePath> copiedFiles = new ArrayList<ChangePath>();
                this.examinePaths(messageInfo, changePaths, newDirs, copiedFiles, diffsRequired);
                if (diffsRequired.size() + copiedFiles.size() > 0) {
                    this.getRequiredInfo(messageInfo, diffsRequired, copiedFiles, changePaths, excludedDiffs);
                }
                if (!this.statusReporter.isStopRequested()) {
                    this.confirmNodeTypes(message, messageInfo);
                    this.processOutsideCopy(message, messageInfo);
                }
            }
            this.resetStatusMessage();
            this.statusReporter.setEngineError("");
            return messageInfo;
        }
        catch (Exception e2) {
            if (e2 instanceof SvnDiffException) {
                throw (SvnDiffException)e2;
            }
            throw new SvnDiffException(message.getRevisionNumber(), (Throwable)e2);
        }
    }

    private void getRequiredInfo(MessageInfo messageInfo, List<ChangePath> diffsRequired, List<ChangePath> copiedPaths, ChangePath[] changePaths, List<ChangePath> excludedDiffs) throws RepositoryClientException, SvnDiffParsingException, IOException, SvnDiffException {
        this.listener.reset();
        ArrayList<ChangePath> combinedPaths = new ArrayList<ChangePath>(diffsRequired);
        combinedPaths.addAll(copiedPaths);
        if (combinedPaths.size() == 0) {
            return;
        }
        boolean isRootAdded = this.isRootAdded(messageInfo, changePaths);
        boolean combinedDiffAtempted = false;
        if (!isRootAdded && excludedDiffs.size() == 0) {
            combinedDiffAtempted = true;
            try {
                this.doCombinedDiffs(messageInfo, combinedPaths, changePaths);
            }
            catch (RepositoryClientException e2) {}
        } else if (combinedPaths.size() > 0) {
            Logs.APP_LOG.debug((Object)"Skipping combined diff due to presence of excluded files");
        }
        if (combinedPaths.size() != 0) {
            try {
                this.processChangePaths(messageInfo, combinedPaths, copiedPaths);
                combinedPaths.clear();
            }
            catch (RepositoryClientException e3) {
                if (combinedDiffAtempted) {
                    Logs.APP_LOG.error((Object)("SVN Error diffing revision " + messageInfo.getRevisionNumber()), (Throwable)e3);
                    throw e3;
                }
                Logs.APP_LOG.warn((Object)("Unable to process single diffs for " + messageInfo.getRevisionNumber()), (Throwable)e3);
            }
        }
        if (!isRootAdded && !combinedDiffAtempted && combinedPaths.size() != 0) {
            this.doCombinedDiffs(messageInfo, combinedPaths, changePaths);
        }
        if (combinedPaths.size() != 0) {
            Logs.APP_LOG.error((Object)("Not all required diffs fetched - missing diffs = " + combinedPaths));
            throw new SvnDiffException("Unable to get diffs for rev " + messageInfo.getRevisionNumber());
        }
        if (!this.statusReporter.isStopRequested()) {
            this.addListenerChangeInfo(messageInfo);
        }
    }

    private void doCombinedDiffs(MessageInfo messageInfo, List<ChangePath> combinedPaths, ChangePath[] changePaths) throws SvnDiffParsingException, RepositoryClientException, IOException {
        Path diffRootPath = this.getDiffRootPath(messageInfo, combinedPaths, changePaths);
        try {
            HashSet<Path> diffPaths = new HashSet<Path>();
            diffPaths.add(diffRootPath);
            this.processPathSet(messageInfo, diffPaths, combinedPaths);
            combinedPaths.clear();
        }
        catch (RepositoryClientException e2) {
            Logs.APP_LOG.debug((Object)("Unable to get combined diff for " + diffRootPath + ":" + messageInfo.getRevisionNumber()), (Throwable)e2);
            Set<Path> firstLevelPaths = this.getFirstLevelPaths(messageInfo, combinedPaths);
            this.processPathSet(messageInfo, firstLevelPaths, combinedPaths);
        }
    }

    private Set<Path> getFirstLevelPaths(MessageInfo messageInfo, List<ChangePath> paths) {
        HashSet<Path> firstLevelPaths = new HashSet<Path>(paths.size());
        for (ChangePath changePath : paths) {
            Path path = messageInfo.getLocalPath(changePath);
            if (path.numComponents() <= 0) continue;
            Path first = new Path(path.getComponent(0));
            firstLevelPaths.add(first);
        }
        return firstLevelPaths;
    }

    private Path getDiffRootPath(MessageInfo messageInfo, List<ChangePath> paths, ChangePath[] changePaths) {
        ChangePath rootChange;
        Path rootPath = this.repositoryInfo.getLocalPath(ChangePathUtil.getCommonRoot(paths), messageInfo.getRevisionNumber());
        while (!rootPath.isRoot() && (rootChange = messageInfo.getChangePath(rootPath)) != null) {
            rootPath = rootPath.getParent();
        }
        return rootPath;
    }

    private void addListenerChangeInfo(MessageInfo messageInfo) {
        messageInfo.addChangeInfoMap(this.listener.getChangeInfos());
        this.listener.reset();
    }

    private List<ChangePath> getExcludedPaths(MessageInfo messageInfo, ChangePath[] changePaths) {
        ArrayList<ChangePath> excludedDiffs = new ArrayList<ChangePath>();
        for (ChangePath changePath : changePaths) {
            char action = changePath.getAction();
            Path localPath = messageInfo.getLocalPath(changePath);
            if (this.repositoryInfo.isPathInRepo(localPath) || action == 'D') continue;
            excludedDiffs.add(changePath);
        }
        return excludedDiffs;
    }

    private void examinePaths(MessageInfo messageInfo, ChangePath[] changePaths, List<ChangePath> newDirs, List<ChangePath> copiedFiles, List<ChangePath> infoRequired) throws RepositoryClientException {
        SvnLogicalPathMatcher matcher = this.repositoryInfo.getPathMatcher();
        ArrayList<ChangePath> addedDirs = new ArrayList<ChangePath>();
        for (ChangePath changePath : changePaths) {
            Path localPath = messageInfo.getLocalPath(changePath);
            if (!this.repositoryInfo.isPathInRepo(localPath)) continue;
            String containerId = matcher.getContainerId(localPath);
            long srcRev = changePath.getCopySrcRevision();
            if (changePath.getAction() == 'A') {
                Info2 pathInfo = messageInfo.getInfo(this.client, localPath);
                if (pathInfo == null) continue;
                if (pathInfo.getKind() == 2) {
                    if (srcRev != -1L && this.repositoryInfo.isPathInRepo(changePath.getCopySrcPath(), srcRev)) continue;
                    addedDirs.add(changePath);
                    continue;
                }
                if (pathInfo.getKind() != 1) continue;
                if (srcRev != -1L) {
                    if (containerId.startsWith("tag:")) continue;
                    copiedFiles.add(changePath);
                    continue;
                }
                infoRequired.add(changePath);
                continue;
            }
            if (changePath.getAction() == 'D') continue;
            boolean opOnAddedPath = false;
            for (ChangePath path : changePaths) {
                if (path.equals(changePath) || !ChangePathUtil.isSubPath(path.getPath(), changePath.getPath())) continue;
                opOnAddedPath = true;
                break;
            }
            if (opOnAddedPath) {
                copiedFiles.add(changePath);
                continue;
            }
            infoRequired.add(changePath);
        }
        while (!addedDirs.isEmpty()) {
            ChangePath addedDir = (ChangePath)addedDirs.remove(0);
            boolean candidate = true;
            Iterator i2 = addedDirs.iterator();
            while (i2.hasNext()) {
                ChangePath changePath;
                changePath = (ChangePath)i2.next();
                if (ChangePathUtil.isSubPath(addedDir.getPath(), changePath.getPath())) {
                    i2.remove();
                    continue;
                }
                if (!ChangePathUtil.isSubPath(changePath.getPath(), addedDir.getPath())) continue;
                candidate = false;
                break;
            }
            if (!candidate || addedDir.getCopySrcPath() != null && !this.repositoryInfo.isPathInRepo(addedDir.getCopySrcPath(), addedDir.getCopySrcRevision())) continue;
            newDirs.add(addedDir);
        }
    }

    private boolean isRootAdded(MessageInfo messageInfo, ChangePath[] changePaths) {
        for (ChangePath changePath : changePaths) {
            Path localPath = messageInfo.getLocalPath(changePath);
            if (!localPath.isRoot()) continue;
            return changePath.getAction() == 'A';
        }
        return false;
    }

    private void processOutsideCopy(LogMessage message, final MessageInfo messageInfo) throws RepositoryClientException, SvnDiffException {
        ChangePath[] changePaths = message.getChangedPaths();
        if (changePaths == null) {
            return;
        }
        for (ChangePath changePath : changePaths) {
            Path localPath = messageInfo.getLocalPath(changePath);
            if (!this.repositoryInfo.isPathInRepo(localPath) || changePath.getCopySrcPath() == null) continue;
            long srcRevision = changePath.getCopySrcRevision();
            Path sourcePath = this.repositoryInfo.getLocalPath(changePath.getCopySrcPath(), srcRevision);
            if (this.repositoryInfo.isPathInRepo(sourcePath, srcRevision)) continue;
            RepositoryWalker walker = new RepositoryWalker(this.repositoryInfo, this.client, message.getRevisionNumber());
            walker.setSkipTags(false);
            RepositoryWalker.Visitor visitor = new RepositoryWalker.Visitor(){

                public boolean visitRemoteEntry(SvnThrottledClient client, Path localPath, long revision, Info2 info) throws RepositoryClientException {
                    return !DiffProcessor.this.statusReporter.isStopRequested() && DiffProcessor.this.addRemoteInfo(info, localPath, messageInfo);
                }

                public boolean visitWorkingCopyEntry(SvnThrottledClient client, File wcFile, Info fileInfo, long revision) throws RepositoryClientException {
                    return !DiffProcessor.this.statusReporter.isStopRequested() && DiffProcessor.this.addWCInfo(wcFile, fileInfo, revision, messageInfo);
                }
            };
            try {
                walker.walkDir(localPath, visitor);
            }
            catch (Exception e2) {
                throw new SvnDiffException("Exception walking dir for " + changePath.getPath() + "@" + message.getRevisionNumber(), (Throwable)e2);
            }
        }
    }

    private boolean addWCInfo(File wcFile, Info fileInfo, long revision, MessageInfo messageInfo) throws RepositoryClientException {
        try {
            if (wcFile.isFile()) {
                this.addNewFileChangeInfoWC(messageInfo, wcFile, fileInfo, revision);
            } else {
                this.addNewDirChangeInfoWC(messageInfo, wcFile, fileInfo, revision);
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.debug((Object)("Exception getting Working coy info on " + wcFile + "(" + fileInfo.getUrl() + ") @" + revision));
            if (e2 instanceof RepositoryClientException) {
                throw (RepositoryClientException)e2;
            }
            throw new RepositoryClientException(e2);
        }
        return true;
    }

    private boolean addRemoteInfo(Info2 info, Path localPath, MessageInfo messageInfo) throws RepositoryClientException {
        try {
            if (info.getKind() == 1) {
                this.addNewFileChangeInfo(messageInfo, localPath);
            } else {
                this.addNewDirChangeInfo(messageInfo, localPath);
            }
        }
        catch (IOException e2) {
            throw new RepositoryClientException(e2);
        }
        return true;
    }

    private void addNewDirChangeInfoWC(MessageInfo messageInfo, File wcFile, Info fileInfo, long revision) throws RepositoryClientException, IOException, DbException {
        ChangeInfo changeInfo = new ChangeInfo();
        changeInfo.setDiffGenerated(false);
        changeInfo.setFileDiff(false);
        Revision.Number rev = new Revision.Number(revision);
        PropertyData[] properties = this.client.properties(wcFile.getCanonicalPath(), (Revision)rev, (Revision)rev);
        this.setPropertyInfo(properties, changeInfo);
        try {
            String serverPath = fileInfo.getUrl().substring(fileInfo.getRepository().length());
            serverPath = SvnURLDecoder.decode(serverPath, "UTF-8");
            Path localPath = this.repositoryInfo.getLocalPath(serverPath, revision);
            this.setStatusMessage("Processing path " + localPath);
            messageInfo.setChangeInfo(localPath, changeInfo);
        }
        catch (UnsupportedEncodingException e2) {
            throw new DbException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewFileChangeInfoWC(MessageInfo messageInfo, File wcFile, Info fileInfo, long revision) throws RepositoryClientException, IOException, DbException {
        ChangeInfo changeInfo = new ChangeInfo();
        changeInfo.setDiffGenerated(false);
        changeInfo.setFileDiff(true);
        Revision.Number rev = new Revision.Number(revision);
        PropertyData[] properties = this.client.properties(wcFile.getCanonicalPath(), (Revision)rev, (Revision)rev);
        this.setPropertyInfo(properties, changeInfo);
        boolean binary = ChangePathUtil.isBinaryMimeType(changeInfo.getUpdatedProperties().get("svn:mime-type"));
        if (!binary && wcFile.exists()) {
            FileInputStream fis = null;
            LineCountingInputStream lcis = null;
            try {
                fis = new FileInputStream(wcFile);
                lcis = new LineCountingInputStream(new BufferedInputStream(fis));
                lcis.readFully();
                changeInfo.incAdded(lcis.getLineCount());
                changeInfo.setFileDiff(true);
            }
            catch (Throwable throwable) {
                IOHelper.close(fis);
                IOHelper.close(lcis);
                throw throwable;
            }
            IOHelper.close(fis);
            IOHelper.close(lcis);
        }
        try {
            String serverPath = fileInfo.getUrl().substring(fileInfo.getRepository().length());
            serverPath = SvnURLDecoder.decode(serverPath, "UTF-8");
            Path localPath = this.repositoryInfo.getLocalPath(serverPath, revision);
            this.setStatusMessage("Processing path " + localPath);
            messageInfo.setChangeInfo(localPath, changeInfo);
        }
        catch (UnsupportedEncodingException e2) {
            throw new DbException(e2);
        }
    }

    private void setPropertyInfo(PropertyData[] properties, ChangeInfo changeInfo) {
        if (properties != null) {
            for (PropertyData property : properties) {
                changeInfo.updateProperty(property.getName(), property.getValue());
            }
        }
    }

    private void addNewDirChangeInfo(MessageInfo messageInfo, Path physicalPath) throws RepositoryClientException {
        if (messageInfo.getChangeInfo(physicalPath) != null) {
            return;
        }
        ChangeInfo changeInfo = new ChangeInfo();
        changeInfo.setFileDiff(false);
        changeInfo.setDiffGenerated(false);
        String url = this.repositoryInfo.getPathURL(physicalPath, messageInfo.getRevisionNumber());
        Revision.Number rev = new Revision.Number(messageInfo.getRevisionNumber());
        PropertyData[] properties = this.client.properties(url, (Revision)rev, (Revision)rev);
        this.setPropertyInfo(properties, changeInfo);
        this.setStatusMessage("Processing path " + physicalPath);
        messageInfo.setChangeInfo(physicalPath, changeInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewFileChangeInfo(MessageInfo messageInfo, Path physicalPath) throws RepositoryClientException, IOException {
        if (messageInfo.getChangeInfo(physicalPath) != null) {
            return;
        }
        String url = this.repositoryInfo.getPathURL(physicalPath, messageInfo.getRevisionNumber());
        File contentFile = null;
        FileInputStream fis = null;
        LineCountingInputStream lcis = null;
        try {
            contentFile = File.createTempFile("FESVNN_", "", this.exportDir);
            Revision.Number rev = new Revision.Number(messageInfo.getRevisionNumber());
            ChangeInfo changeInfo = new ChangeInfo();
            changeInfo.setFileDiff(true);
            changeInfo.setDiffGenerated(false);
            PropertyData[] properties = this.client.properties(url, (Revision)rev, (Revision)rev);
            this.setPropertyInfo(properties, changeInfo);
            boolean binary = ChangePathUtil.isBinaryMimeType(changeInfo.getUpdatedProperties().get("svn:mime-type"));
            if (!binary) {
                Info2 info = messageInfo.getInfo(this.client, physicalPath);
                if (info == null || info.getKind() != 1) {
                    Logs.APP_LOG.error((Object)("Not exporting content for " + url + " in rev " + messageInfo.getRevisionNumber() + " as it is a directory."));
                    return;
                }
                this.client.doExport(url, contentFile.getAbsolutePath(), (Revision)rev, (Revision)rev, true, true, false, "LF");
                if (contentFile.exists() && !changeInfo.getUpdatedProperties().containsKey("svn:special")) {
                    fis = new FileInputStream(contentFile);
                    lcis = new LineCountingInputStream(new BufferedInputStream(fis));
                    lcis.readFully();
                    changeInfo.incAdded(lcis.getLineCount());
                    changeInfo.setFileDiff(true);
                }
            }
            this.setStatusMessage("Processing path " + physicalPath);
            messageInfo.setChangeInfo(physicalPath, changeInfo);
        }
        finally {
            IOHelper.close(fis);
            IOHelper.close(lcis);
            IOHelper.deleteFile(contentFile);
        }
    }

    public void requestStop() {
        this.client.cancel();
    }
}

