/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Region {
    private int start;
    private int end;
    private Map properties;

    public Region(int start, int end, Map properties) {
        this.guardBounds(start, end);
        this.start = start;
        this.end = end;
        if (properties != null) {
            this.properties = Collections.unmodifiableMap(new HashMap(properties));
        }
    }

    public Region(Region that, Map properties) {
        this.start = that.start;
        this.end = that.end;
        if (properties != null) {
            this.properties = Collections.unmodifiableMap(new HashMap(properties));
        }
    }

    public Region(int start, int end) {
        this(start, end, null);
    }

    public Region subRegion(int start, int end) {
        if (start < this.start || end > this.end) {
            throw new IndexOutOfBoundsException();
        }
        return new Region(start, end, this.properties);
    }

    public Region translate(int delta) {
        return new Region(this.start + delta, this.end + delta, this.properties);
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Object getPropertyValue(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean contains(int x) {
        return this.start <= x && x <= this.end;
    }

    public boolean isNestedBy(Region r) {
        return r.start <= this.start && r.end >= this.end;
    }

    public boolean nests(Region r) {
        return this.start <= r.start && this.end >= r.end;
    }

    public boolean overlapsNotNested(Region r) {
        if (this.start < r.start && r.start < this.end && r.end > this.end) {
            return true;
        }
        return this.start < r.end && r.end < this.end && r.start < this.start;
    }

    public Region intersection(Region r) {
        if (r.start < this.start) {
            if (r.end < this.start) {
                return null;
            }
            if (r.end == this.start) {
                return null;
            }
            if (r.end <= this.end) {
                return new Region(this.start, r.end, r.properties);
            }
            return new Region(this.start, this.end, r.properties);
        }
        if (r.start > this.end) {
            return null;
        }
        if (r.start == this.end) {
            return null;
        }
        if (r.end <= this.end) {
            return new Region(r.start, r.end, r.properties);
        }
        return new Region(r.start, this.end, r.properties);
    }

    public boolean sameSpan(Region r) {
        return r.getStart() == this.getStart() && r.getEnd() == this.getEnd();
    }

    public String toString() {
        String res = "Region{st=" + this.start + ",end=" + this.end + ",props{";
        String sep = "";
        if (this.properties != null) {
            for (String key : this.properties.keySet()) {
                String val = (String)this.properties.get(key);
                res = res + sep + key + "=" + val;
                sep = ",";
            }
        }
        res = res + "}}";
        return res;
    }

    private void guardBounds(int start, int end) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("start index " + start + " < 0");
        }
        if (end < 0) {
            throw new IndexOutOfBoundsException("end index " + end + " < 0");
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start index " + start + " > end index " + end);
        }
    }
}

