/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.cenqua.fisheye.config.DB0EAV;
import com.cenqua.fisheye.infinitydb.InfinityDbUtil;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._EntityClass;
import com.cenqua.obfuscate.idbk4ui8v._k4ui8vIDB;
import java.io.IOException;

public class LoginEAV {
    private static final _EntityClass LOGIN_TABLE = DB0EAV.PERSISTENT_LOGIN;
    private final _k4ui8vIDB db;

    public LoginEAV(_k4ui8vIDB db) {
        this.db = db;
    }

    public LoginCookie findCookie(String username, long loginId) throws DbException {
        _Cu cu = _Cu.alloc().append(LOGIN_TABLE);
        try {
            cu.append(username);
            cu.append(loginId);
            int p1 = cu.length();
            if (this.db.next(cu, p1)) {
                LoginCookie loginCookie = LoginEAV.readLoginCookie(cu);
                return loginCookie;
            }
            LoginCookie loginCookie = null;
            return loginCookie;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    public LoginCookie addRememberMeCookie(String username, String rnd) throws DbException {
        LoginCookie c2 = new LoginCookie(this.makeId(), username, rnd, System.currentTimeMillis(), 1);
        this.updateCookie(c2);
        return c2;
    }

    public LoginCookie addPreCookedUrlCookie(String username, String rnd, String url, boolean recursiveUrl) throws DbException {
        LoginCookie c2 = this.findExistingPreCookedUrl(username, url, recursiveUrl);
        if (c2 == null) {
            c2 = new LoginCookie(this.makeId(), username, rnd, System.currentTimeMillis(), 2, url, recursiveUrl);
            this.updateCookie(c2);
        }
        return c2;
    }

    private LoginCookie findExistingPreCookedUrl(String username, String url, boolean recursiveUrl) throws DbException {
        _Cu cu = _Cu.alloc().append(LOGIN_TABLE);
        try {
            cu.append(username);
            int p1 = cu.length();
            while (this.db.next(cu, p1)) {
                LoginCookie c2 = LoginEAV.readLoginCookie(cu);
                if (c2.getType() != 2 || recursiveUrl != c2.isRecursiveUrl() || !StringUtil.equal(url, c2.getUrl())) continue;
                LoginCookie loginCookie = c2;
                return loginCookie;
            }
            LoginCookie loginCookie = null;
            return loginCookie;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    public void updateCookie(LoginCookie login) throws DbException {
        _Cu cu = _Cu.alloc().append(LOGIN_TABLE);
        try {
            cu.append(login.getUsername());
            cu.append(login.getLoginId());
            int p1 = cu.length();
            cu.append(login.getType());
            cu.append(login.getRnd());
            cu.append(login.getCreateDate());
            cu.append(login.isRecursiveUrl());
            if (login.getUrl() != null) {
                cu.append(login.getUrl());
            } else {
                cu.append(0L);
            }
            this.db.update(cu, p1);
            this.db.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    private long makeId() throws DbException {
        try {
            return InfinityDbUtil.incrementLong(this.db, DB0EAV.CONSTANTS, "persistentlogin.counter");
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void invalidateCookie(String username, long loginId) throws DbException {
        _Cu cu = _Cu.alloc().append(LOGIN_TABLE);
        try {
            cu.append(username);
            cu.append(loginId);
            int p1 = cu.length();
            if (this.db.next(cu, p1)) {
                this.db.delete(cu);
                this.db.commit();
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    public void invalidateCookies(String username, int type) throws DbException {
        _Cu cu = _Cu.alloc().append(LOGIN_TABLE);
        try {
            cu.append(username);
            int p1 = cu.length();
            while (this.db.next(cu, p1)) {
                LoginCookie c2 = LoginEAV.readLoginCookie(cu);
                if (c2.getType() != type) continue;
                this.db.delete(cu);
            }
            this.db.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    private static LoginCookie readLoginCookie(_Cu cu) {
        int p1 = cu.skipEntityClass(0);
        String username = cu.stringAt(p1);
        p1 = cu.skipString(p1);
        long loginId = cu.longAt(p1);
        p1 = cu.skipLong(p1);
        int type = (int)cu.longAt(p1);
        p1 = cu.skipLong(p1);
        String rnd = cu.stringAt(p1);
        p1 = cu.skipString(p1);
        long date = cu.longAt(p1);
        p1 = cu.skipLong(p1);
        boolean recursiveUrl = cu.booleanAt(p1);
        p1 = cu.skipBoolean(p1);
        String url = null;
        if (cu.typeAt(p1) == 2) {
            url = cu.stringAt(p1);
        }
        return new LoginCookie(loginId, username, rnd, date, type, url, recursiveUrl);
    }
}

