/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.FEGroupEAV;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.user.FEUserEAV;
import com.cenqua.fisheye.user.LoginEAV;
import com.cenqua.fisheye.web.UserProfile;
import com.cenqua.fisheye.web.Watch;
import com.cenqua.fisheye.web.WatchEAV;
import com.cenqua.obfuscate.idbk4ui8v._k4ui8vIDB;
import java.io.IOException;
import java.util.List;

public class UserRenamer {
    private final _k4ui8vIDB db;

    public UserRenamer(_k4ui8vIDB db) {
        this.db = db;
    }

    public void rename(String oldname, String newname) throws DbException {
        FEUserEAV ueav = new FEUserEAV(this.db);
        FEGroupEAV geav = new FEGroupEAV(this.db);
        LoginEAV leav = new LoginEAV(this.db);
        WatchEAV weav = new WatchEAV(this.db);
        if (ueav.usernameExists(newname)) {
            throw new DbException("New name " + newname + " already exists");
        }
        FEUser user = ueav.load(oldname);
        UserProfile profile = ueav.loadProfile(oldname);
        List<String> groups = geav.listGroupsForUser(oldname);
        for (String group : groups) {
            geav.removeUserFromGroup(group, oldname);
        }
        user.setUsername(newname);
        profile.setUsername(newname);
        ueav.update(user);
        ueav.updateProfile(profile);
        ueav.setCrucibleEnabled(newname, user.isCrucibleEnabled());
        for (String group : groups) {
            geav.addUserToGroup(group, newname);
        }
        leav.invalidateCookies(oldname, 2);
        leav.invalidateCookies(oldname, 1);
        for (Watch watch : weav.getWatchesForUser(oldname)) {
            watch.setUser(newname);
            weav.update(watch);
        }
        ueav.delete(oldname);
        try {
            this.db.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }
}

