/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.plugin;

import com.cenqua.fisheye.user.plugin.AbstractFishEyeAuthenticator;
import com.cenqua.fisheye.user.plugin.AuthToken;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;

public class ExampleFishEyeAuthenticator
extends AbstractFishEyeAuthenticator {
    private Properties props;

    public void init(Properties cfg) throws Exception {
        this.props = cfg;
    }

    public void close() {
        System.out.println("Example: close() called");
    }

    public AuthToken checkPassword(String username, String password) {
        if (username == null || "".equals(username)) {
            return null;
        }
        if (password == null || "".equals(password)) {
            return null;
        }
        String prop = "user." + username;
        String expected = this.props.getProperty(prop);
        if (expected == null || !expected.equals(password)) {
            return null;
        }
        System.out.println("Example: found user " + username);
        return new ExampleAuthToken(username);
    }

    public AuthToken recreateAuth(String username) {
        String prop = "user." + username;
        if (this.props.containsKey(prop)) {
            System.out.println("Example: found user, recreating " + username);
            return new ExampleAuthToken(username);
        }
        return null;
    }

    public boolean hasPermissionToAccess(AuthToken tok, String repname, String constraint) {
        System.out.println("Example: hasPermissionToAccess? " + tok + " " + repname + " " + constraint);
        if (tok == null) {
            return false;
        }
        String prop = "repos." + repname;
        if (this.props.containsKey(prop)) {
            System.out.println("props = " + this.props);
            String[] usersList = this.props.getProperty(prop).split(",");
            HashSet<String> users = new HashSet<String>(Arrays.asList(usersList));
            return users.contains(tok.getUsername());
        }
        System.out.println("No prop = " + prop + " configured. Access granted to all users.");
        return true;
    }

    public static class ExampleAuthToken
    implements AuthToken {
        private final String username;

        public ExampleAuthToken(String username) {
            this.username = username;
        }

        public String getUsername() {
            return this.username;
        }

        public String getEmail() {
            return this.username + "@foo.com";
        }

        public String getDisplayName() {
            return this.username.substring(0, 1).toUpperCase() + this.username.substring(1);
        }
    }
}

