/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ISO8601DateHelper {
    private static final Pattern PARSER = Pattern.compile("(\\d\\d(\\d\\d)?)-?(\\d\\d)-?(\\d\\d)([T ](\\d\\d):?(\\d\\d):?(\\d\\d)(\\.(\\d+))?)?(Z|((\\+|-)?(\\d\\d)(:?(\\d\\d))?))?$", 2);

    public static Date parse(String s) throws InvalidDateException {
        Matcher m = PARSER.matcher(s);
        if (!m.matches()) {
            throw new InvalidDateException("date did not match pattern");
        }
        int year = Integer.parseInt(m.group(1));
        if (m.group(2) == null) {
            year += 1900;
        }
        int month = Integer.parseInt(m.group(3));
        int day = Integer.parseInt(m.group(4));
        int hour = 0;
        int min = 0;
        int sec = 0;
        if (m.group(5) != null) {
            hour = Integer.parseInt(m.group(6));
            min = Integer.parseInt(m.group(7));
            sec = Integer.parseInt(m.group(8));
        }
        int msec = 0;
        if (m.group(9) != null) {
            float secFrac = Float.parseFloat(m.group(9));
            msec = (int)(secFrac * 1000.0f);
        }
        TimeZone tz = TimeZone.getTimeZone("GMT");
        if (m.group(12) != null) {
            boolean plus = m.group(13) == null || m.group(13).equals("+");
            String tzhh = m.group(14);
            String tzmm = m.group(16);
            if (tzmm == null) {
                tzmm = "00";
            }
            tz = TimeZone.getTimeZone("GMT" + (plus ? "+" : "-") + tzhh + ":" + tzmm);
        }
        GregorianCalendar cal = new GregorianCalendar(tz);
        cal.clear();
        cal.set(year, month - 1, day, hour, min, sec);
        cal.set(14, msec);
        return cal.getTime();
    }

    public static String toIsoDate(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        StringBuffer buffer = new StringBuffer();
        buffer.append(calendar.get(1));
        buffer.append("-");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(2) + 1));
        buffer.append("-");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(5)));
        buffer.append("T");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(11)));
        buffer.append(":");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(12)));
        buffer.append(":");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(13)));
        buffer.append(".");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(14) / 10));
        buffer.append("Z");
        return buffer.toString();
    }

    public static String toIsoDate(long date) {
        return ISO8601DateHelper.toIsoDate(new Date(date));
    }

    private static String twoDigit(int i2) {
        if (i2 >= 0 && i2 < 10) {
            return "0" + String.valueOf(i2);
        }
        return String.valueOf(i2);
    }

    public static String toXmlRpcDate(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        StringBuffer buffer = new StringBuffer();
        buffer.append(calendar.get(1));
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(2) + 1));
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(5)));
        buffer.append("T");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(11)));
        buffer.append(":");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(12)));
        buffer.append(":");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(13)));
        return buffer.toString();
    }

    public static String toXmlRpcDate(long date) {
        return ISO8601DateHelper.toXmlRpcDate(new Date(date));
    }

    public static class InvalidDateException
    extends Exception {
        public InvalidDateException(String message) {
            super(message);
        }
    }
}

