/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.cvsrep.LineWriter;
import java.util.Arrays;
import java.util.Collection;

public class StringUtil {
    public static StringBuffer pad(StringBuffer buf, int i2, int pad) {
        String s = Integer.toString(i2);
        while (pad > s.length()) {
            buf.append('0');
            --pad;
        }
        buf.append(s);
        return buf;
    }

    public static void append(StringBuffer buf, String pad, int padCount) {
        for (int i2 = 0; i2 < padCount; ++i2) {
            buf.append(pad);
        }
    }

    public static void stripEOL(StringBuffer s) {
        if (s.length() > 0 && s.charAt(s.length() - 1) == '\n') {
            s.setLength(s.length() - 1);
        }
        if (s.length() > 0 && s.charAt(s.length() - 1) == '\r') {
            s.setLength(s.length() - 1);
        }
    }

    public static String stripEOL(String s) {
        if (s == null) {
            return null;
        }
        if (s.endsWith(LineWriter.NEWLINE_STR)) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.endsWith(LineWriter.CARRIAGERETURN_STR)) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String replace(String str, String find, String replace) {
        StringBuffer result = new StringBuffer(str);
        int start = 0;
        while (-1 != (start = result.indexOf(find, start))) {
            result.replace(start, start + find.length(), replace);
            start += replace.length();
        }
        return result.toString();
    }

    public static int stringHashCode(CharSequence line) {
        int h2 = 0;
        int len = line.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = line.charAt(i2);
            h2 = 31 * h2 + c2;
        }
        return h2;
    }

    public static boolean equal(CharSequence a2, CharSequence b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        if (a2.length() != b2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < a2.length(); ++i2) {
            if (a2.charAt(i2) == b2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static boolean nullOrEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static int editDistance(CharSequence s, CharSequence t) {
        int j;
        int i2;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d2 = new int[n + 1][m + 1];
        for (i2 = 0; i2 <= n; ++i2) {
            d2[i2][0] = i2;
        }
        for (j = 0; j <= m; ++j) {
            d2[0][j] = j;
        }
        for (i2 = 1; i2 <= n; ++i2) {
            char s_i = s.charAt(i2 - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d2[i2][j] = StringUtil.min(d2[i2 - 1][j] + 1, d2[i2][j - 1] + 1, d2[i2 - 1][j - 1] + cost);
            }
        }
        return d2[n][m];
    }

    private static int min(int a2, int b2, int c2) {
        int mi = a2;
        if (b2 < mi) {
            mi = b2;
        }
        if (c2 < mi) {
            mi = c2;
        }
        return mi;
    }

    public static boolean isPrintableAscii(char c2) {
        return ' ' <= c2 && c2 <= '~';
    }

    public static int indexOfEOL(String str) {
        int nlIdx = str.indexOf(10);
        int crIdx = str.indexOf(13);
        return StringUtil.minPositive(nlIdx, crIdx);
    }

    public static String firstLineOf(String str, int limit, boolean hardLimit, boolean wholeWord, boolean addElipsis) {
        String elip;
        String tmp = str.trim();
        int eolIdx = StringUtil.indexOfEOL(tmp);
        if (limit == -1) {
            return eolIdx == -1 ? tmp : tmp.substring(0, eolIdx);
        }
        if (eolIdx > 0 && eolIdx < limit) {
            return tmp.substring(0, eolIdx);
        }
        if (tmp.length() < limit) {
            return tmp;
        }
        String string = elip = addElipsis ? "..." : "";
        if (!wholeWord) {
            return tmp.substring(0, limit) + elip;
        }
        int before = StringUtil.nearestWhiteSpaceBefore(tmp, limit);
        int after = StringUtil.nearestWhiteSpaceAfter(tmp, limit);
        if (!hardLimit) {
            int space = limit - before > Math.abs(after - limit) ? after : before;
            return space != -1 ? tmp.substring(0, space) + elip : tmp.substring(0, limit) + elip;
        }
        return before != -1 ? tmp.substring(0, before) + elip : tmp.substring(0, limit) + elip;
    }

    public static int nearestWhiteSpaceBefore(String str, int idx) {
        int before;
        int n = before = idx < str.length() ? idx : str.length() - 1;
        while (before > -1 && !Character.isWhitespace(str.charAt(before))) {
            --before;
        }
        return before;
    }

    public static int nearestWhiteSpaceAfter(String str, int idx) {
        int after;
        for (after = idx; after < str.length() && !Character.isWhitespace(str.charAt(after)); ++after) {
        }
        after = after == str.length() ? -1 : after;
        return after;
    }

    private static int minPositive(int a2, int b2) {
        if (a2 < 0 && b2 < 0) {
            return -1;
        }
        if (a2 < 0 || b2 < 0) {
            return a2 < 0 ? b2 : a2;
        }
        return Math.min(a2, b2);
    }

    public static boolean endsWith(CharSequence s, CharSequence test) {
        int tl = test.length();
        int sl = s.length();
        if (sl < tl) {
            return false;
        }
        int start = sl - tl;
        for (int i2 = 0; i2 < tl && i2 + start < sl; ++i2) {
            if (s.charAt(i2 + start) == test.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static String join(String[] list, String separator) {
        return StringUtil.join(Arrays.asList(list), separator);
    }

    public static String join(Collection list, String separator) {
        String sep = "";
        StringBuilder buf = new StringBuilder();
        for (Object o : list) {
            buf.append(sep).append(o);
            sep = separator;
        }
        return buf.toString();
    }

    public static String pluralise(int val, String singular, String plural) {
        return val + " " + (val == 1 ? singular : plural);
    }

    public static boolean hasUpperCaseChar(CharSequence input) {
        if (input == null) {
            return false;
        }
        for (int i2 = 0; i2 < input.length(); ++i2) {
            if (!Character.isUpperCase(input.charAt(i2))) continue;
            return true;
        }
        return false;
    }
}

