/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.logging.Logs;

public class Timer {
    private long startTime;
    private String timerName;

    private void output(String message) {
        Logs.PERF_LOG.info((Object)message);
    }

    public Timer(String timerName) {
        this.timerName = timerName;
        this.reset();
        this.output("-> " + timerName + this.getMemString());
    }

    public void reset() {
        this.startTime = System.currentTimeMillis();
    }

    private String getMemString() {
        long currentHeapSize = Runtime.getRuntime().totalMemory();
        long freeMem = Runtime.getRuntime().freeMemory();
        long currentUsed = currentHeapSize - freeMem;
        return " mem_usage = " + currentUsed + " heapsize = " + currentHeapSize + " freemem = " + freeMem;
    }

    private String getTimeString() {
        return " time " + (System.currentTimeMillis() - this.startTime) + "ms";
    }

    public void mark(String markPoint) {
        this.output("-- " + this.timerName + " at " + markPoint + this.getTimeString() + this.getMemString());
    }

    public void end() {
        this.output("<- " + this.timerName + this.getTimeString() + this.getMemString());
    }
}

