/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.vis.AgeBlameColourer;
import com.cenqua.fisheye.vis.AnnotationColourer;
import com.cenqua.fisheye.vis.ExtendedStackedBarRenderer;
import com.cenqua.fisheye.vis.LegendValue;
import com.cenqua.fisheye.vis.LineCountChart;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.TextAnchor;
import org.jfree.util.SortOrder;

public class AnnotationChart {
    private static final Properties COLOR_PROPS = new Properties();

    public String getImageContentType() {
        return "image/png";
    }

    public ChartRenderingInfo renderAgeHistogram(JFreeChart chart, int w, int h2, OutputStream out) throws IOException {
        ChartRenderingInfo info = new ChartRenderingInfo();
        BufferedImage image = chart.createBufferedImage(w, h2, info);
        if (out != null) {
            ChartUtilities.writeBufferedImageAsPNG((OutputStream)out, (BufferedImage)image);
        }
        return info;
    }

    public JFreeChart createAgeBlameHistogram(final CategoryDataset dataset, AnnotationColourer colourer) {
        JFreeChart chart = ChartFactory.createStackedBarChart((String)"", (String)"age", (String)"loc", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        ExtendedStackedBarRenderer renderer = new ExtendedStackedBarRenderer(){

            public Paint getItemOutlinePaint(int row, int column) {
                return dataset.getValue(row, column).intValue() > 0 ? super.getItemOutlinePaint(row, column) : Color.WHITE;
            }
        };
        plot.setColumnRenderingOrder(SortOrder.ASCENDING);
        for (int i2 = 0; i2 < dataset.getRowCount(); ++i2) {
            String author = (String)((Object)dataset.getRowKey(i2));
            int seriesIndex = ((AgeBlameColourer)colourer).authPosition(author);
            Paint itemPaint = this.getItemPaintFromProps(".annotAuth" + seriesIndex);
            renderer.setSeriesPaint(i2, itemPaint);
        }
        this.configureBarChart(chart, (CategoryItemRenderer)renderer, plot);
        renderer.setBaseItemLabelsVisible(false);
        AgeBlameToolTipGenerator generator = new AgeBlameToolTipGenerator();
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)generator);
        renderer.setMaximumBarWidth(0.1);
        plot.setRenderer((CategoryItemRenderer)renderer);
        return chart;
    }

    public JFreeChart createAgeHistogram(XYDataset dataset, final AnnotationColourer data) {
        DefaultCategoryDataset barData = new DefaultCategoryDataset();
        List<LegendValue> legend = data.getLegend();
        Iterator<LegendValue> i$ = legend.iterator();
        while (i$.hasNext()) {
            LegendValue aLegend;
            LegendValue val = aLegend = i$.next();
            barData.addValue((double)val.getLinesOfCode(), (Comparable)((Object)""), (Comparable)((Object)val.getName()));
        }
        JFreeChart chart = ChartFactory.createBarChart(null, (String)"age", (String)"loc", (CategoryDataset)barData, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        BarRenderer renderer = new BarRenderer(){

            public Paint getItemPaint(int row, int column) {
                String key = ".annotAge" + data.getLegendStyleKey(column);
                Paint itemPaint = AnnotationChart.this.getItemPaintFromProps(key);
                return itemPaint == null ? super.getItemPaint(row, column) : itemPaint;
            }
        };
        this.configureBarChart(chart, (CategoryItemRenderer)renderer, plot);
        renderer.setDrawBarOutline(true);
        renderer.setMaximumBarWidth(0.1);
        plot.setRenderer((CategoryItemRenderer)renderer);
        return chart;
    }

    private void configureBarChart(JFreeChart chart, CategoryItemRenderer renderer, CategoryPlot plot) {
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBorderVisible(false);
        CategoryAxis domainAxis = new CategoryAxis();
        domainAxis.setLowerMargin(0.01);
        domainAxis.setUpperMargin(0.01);
        domainAxis.setMaximumCategoryLabelLines(3);
        renderer.setBaseItemLabelsVisible(true);
        renderer.setSeriesItemLabelsVisible(0, true);
        renderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER));
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        StandardCategoryToolTipGenerator generator = new StandardCategoryToolTipGenerator("{1}, {2}", NumberFormat.getInstance());
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)generator);
        plot.setDomainAxis(0, domainAxis, true);
        plot.getDomainAxis().setVisible(true);
        plot.getRangeAxis().setVisible(false);
        plot.getRangeAxis().setUpperMargin(0.2);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setOutlinePaint((Paint)Color.white);
    }

    public ChartRenderingInfo renderAuthorPieChart(PieDataset dataset, int w, int h2, OutputStream out) throws IOException {
        JFreeChart chart = this.createBlameChart(dataset);
        ChartRenderingInfo info = new ChartRenderingInfo();
        BufferedImage image = chart.createBufferedImage(w, h2, info);
        if (out != null) {
            ChartUtilities.writeBufferedImageAsPNG((OutputStream)out, (BufferedImage)image);
        }
        return info;
    }

    public JFreeChart createBlameChart(PieDataset dataset) {
        JFreeChart chart = ChartFactory.createPieChart3D(null, (PieDataset)dataset, (boolean)false, (boolean)true, (boolean)false);
        chart.setBorderVisible(false);
        chart.setBorderPaint((Paint)Color.white);
        chart.setBorderStroke(null);
        chart.setBackgroundPaint((Paint)Color.white);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setLabelFont(new Font("SansSerif", 0, 12));
        plot.setNoDataMessage("No data available");
        plot.setCircular(true);
        plot.setLabelGap(0.04);
        plot.setIgnoreZeroValues(true);
        plot.setIgnoreNullValues(true);
        plot.setOutlinePaint((Paint)Color.white);
        plot.setOutlineStroke(null);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator("{0} {1} ({2})"));
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} {2}"));
        plot.setLabelBackgroundPaint((Paint)Color.white);
        plot.setLabelOutlinePaint((Paint)Color.gray.brighter());
        plot.setLabelShadowPaint((Paint)Color.white);
        plot.setLabelLinkPaint((Paint)Color.gray.brighter());
        for (int i2 = 0; i2 < dataset.getItemCount(); ++i2) {
            Paint itemPaint = this.getItemPaintFromProps(".annotAuth" + i2);
            if (itemPaint == null) continue;
            plot.setSectionPaint(dataset.getKey(i2), itemPaint);
        }
        return chart;
    }

    private Paint getItemPaintFromProps(String key) {
        try {
            Object prop = COLOR_PROPS.get(key);
            if (prop != null) {
                return Color.decode("0x" + prop);
            }
        }
        catch (NumberFormatException e2) {
            Logs.APP_LOG.warn((Object)e2.getMessage());
        }
        return null;
    }

    static {
        try {
            COLOR_PROPS.load(LineCountChart.class.getResourceAsStream("colours.properties"));
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)e2.getMessage(), (Throwable)e2);
        }
    }

    private static class AgeBlameToolTipGenerator
    extends StandardCategoryToolTipGenerator {
        public AgeBlameToolTipGenerator() {
            super("{0}, {2}", NumberFormat.getInstance());
        }

        public String generateToolTip(CategoryDataset dataset, int row, int column) {
            Number value = dataset.getValue(row, column);
            int val = value != null ? value.intValue() : -1;
            return val > 0 ? super.generateToolTip(dataset, row, column) : "";
        }
    }
}

