/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.bucket.CalculatedBucketGraphPie;
import com.cenqua.fisheye.vis.LineCountChartUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class LineCountChartPie {
    public BufferedImage renderPathHistoryImage(CalculatedBucketGraphPie graphs, int w, int h2) {
        JFreeChart chart = this.createLineCommitHistoryChartPie(graphs);
        return LineCountChartUtils.renderChart(chart, graphs, w, h2);
    }

    private JFreeChart createLineCommitHistoryChartPie(CalculatedBucketGraphPie graphs) {
        PiePlot plot = this.createPiePlot((PieDataset)graphs.getPieData());
        plot.setOutlineVisible(false);
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.setPadding(new RectangleInsets(1.0, 1.0, 1.0, 15.0));
        chart.setBackgroundPaint((Paint)Color.white);
        chart.getLegend().setPosition(RectangleEdge.RIGHT);
        chart.setBorderVisible(false);
        chart.setBorderPaint((Paint)Color.white);
        chart.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
        return chart;
    }

    private PiePlot createPiePlot(PieDataset pieData) {
        PiePlot plot = new PiePlot(pieData);
        plot.setBaseSectionOutlinePaint((Paint)Color.WHITE);
        plot.setBaseSectionOutlineStroke((Stroke)new BasicStroke(3.0f, 1, 1));
        for (int i2 = 0; i2 < pieData.getItemCount(); ++i2) {
            plot.setSectionPaint(pieData.getKey(i2), LineCountChartUtils.getPieColour(i2));
        }
        plot.setShadowPaint(null);
        plot.setLabelGenerator(null);
        plot.setLegendItemShape((Shape)new Rectangle(22, 22));
        plot.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} ({1} - {2})"));
        return plot;
    }
}

