/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.filters.JsonRewrite;
import com.cenqua.fisheye.web.security.CaptchaManager;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginServlet
extends HttpServlet {
    public static final String ORIG_URL_SESSION_KEY = LoginServlet.class.getName() + ".ORIG_URL";
    private static final String ORIG_URL_REQUEST_KEY = "origUrl";

    public static void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String origUrl = ServletUtils.getOriginalRequestURIAndQueryString(req);
        req.getSession().setAttribute(ORIG_URL_SESSION_KEY, (Object)origUrl);
        if (JsonRewrite.isAjaxRequest(req)) {
            req.getRequestDispatcher("/WEB-INF/jsp/login_json.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        } else {
            req.getRequestDispatcher("/WEB-INF/jsp/login.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String captchaId = req.getParameter("captcha");
        if (!StringUtil.nullOrEmpty(captchaId)) {
            this.sendCaptchaImage(req, resp, captchaId);
        } else {
            this.doLogin(req, resp);
        }
    }

    private void sendCaptchaImage(HttpServletRequest req, HttpServletResponse resp, String captchaId) throws IOException {
        BufferedImage challenge = CaptchaManager.getInstance().getImageChallengeForID(captchaId, req.getLocale());
        resp.setContentType("image/png");
        resp.setHeader("Cache-Control", "no-store");
        resp.setHeader("Pragma", "no-cache");
        resp.setDateHeader("Expires", 0L);
        ImageIO.write((RenderedImage)challenge, "PNG", (OutputStream)resp.getOutputStream());
    }

    private void doLogin(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username = req.getParameter("username");
        String password = req.getParameter("password");
        String destUrl = req.getParameter(ORIG_URL_REQUEST_KEY);
        boolean rememberme = "yes".equals(req.getParameter("rememberme"));
        if (username != null) {
            UserLogin user;
            try {
                UserManager um = AppConfig.getsConfig().getUserManager();
                user = um.login(req, resp, username, password, rememberme);
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)"error checking password", (Throwable)e2);
                req.setAttribute("errormsg", (Object)"Password incorrect or unknown user");
                req.getRequestDispatcher("/WEB-INF/jsp/login.jsp").forward((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            catch (LicensePolicyException e3) {
                Logs.APP_LOG.warn((Object)"problem logging in user", (Throwable)e3);
                req.setAttribute("errormsg", (Object)e3.getMessage());
                req.getRequestDispatcher("/WEB-INF/jsp/login.jsp").forward((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            if (user == null) {
                req.setAttribute("errormsg", (Object)"Password incorrect or unknown user");
                req.getRequestDispatcher("/WEB-INF/jsp/login.jsp").forward((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            if ((destUrl == null || destUrl.length() == 0) && (destUrl = (String)req.getSession().getAttribute(ORIG_URL_SESSION_KEY)) == null) {
                destUrl = req.getContextPath() + "/";
            }
        } else {
            req.getRequestDispatcher("/WEB-INF/jsp/login.jsp").forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        PreferenceManager.loadUserPreference(req);
        PreferenceManager.touchCookie(req, resp);
        resp.sendRedirect(destUrl);
    }
}

